/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.util;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public final class OneEightCompat {
    private static final Random RANDOM = new Random();
    public static final EnumFacing[] HORIZONTALS = new EnumFacing[]{EnumFacing.SOUTH, EnumFacing.EAST, EnumFacing.NORTH, EnumFacing.WEST};

    public static int calcRedstone(TileEntity te) {
        return te instanceof IInventory ? Container.func_94526_b((IInventory)((IInventory)te)) : 0;
    }

    public static double getDistanceSqToCenter(Entity entity, int x, int y, int z) {
        double dx = (double)x + 0.5 - entity.field_70165_t;
        double dy = (double)y + 0.5 - entity.field_70163_u;
        double dz = (double)z + 0.5 - entity.field_70161_v;
        return dx * dx + dy * dy + dz * dz;
    }

    public static EnumFacing getHorizontalFacing(Entity entity) {
        return OneEightCompat.getHorizontal(MathHelper.func_76128_c((double)(entity.field_70177_z * 4.0f / 360.0f + 0.5f)) & 3);
    }

    public static EnumFacing getHorizontal(int index) {
        return HORIZONTALS[MathHelper.func_76130_a((int)(index % HORIZONTALS.length))];
    }

    public static void dropInventoryItems(World world, int x, int y, int z, IInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null) continue;
            OneEightCompat.spawnItemStack(world, x, y, z, stack);
        }
    }

    private static void spawnItemStack(World world, double x, double y, double z, ItemStack stack) {
        float offsetX = RANDOM.nextFloat() * 0.8f + 0.1f;
        float offsetY = RANDOM.nextFloat() * 0.8f + 0.1f;
        float offsetZ = RANDOM.nextFloat() * 0.8f + 0.1f;
        while (stack.field_77994_a > 0) {
            int count = RANDOM.nextInt(21) + 10;
            if (count > stack.field_77994_a) {
                count = stack.field_77994_a;
            }
            stack.field_77994_a -= count;
            EntityItem entity = new EntityItem(world, x + (double)offsetX, y + (double)offsetY, z + (double)offsetZ, new ItemStack(stack.func_77973_b(), count, stack.func_77960_j()));
            if (stack.func_77942_o()) {
                entity.func_92059_d().func_77982_d((NBTTagCompound)stack.func_77978_p().func_74737_b());
            }
            float velocity = 0.05f;
            entity.field_70159_w = RANDOM.nextGaussian() * (double)0.05f;
            entity.field_70181_x = RANDOM.nextGaussian() * (double)0.05f + 0.2;
            entity.field_70179_y = RANDOM.nextGaussian() * (double)0.05f;
            world.func_72838_d((Entity)entity);
        }
    }

    private OneEightCompat() {
    }
}

