/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.common.entity;

import com.google.common.base.Optional;
import com.mrcrayfish.vehicle.network.PacketHandler;
import com.mrcrayfish.vehicle.network.message.MessageSyncPlayerData;
import com.mrcrayfish.vehicle.network.message.MessageSyncPlayerGasPumpPos;
import com.mrcrayfish.vehicle.network.message.MessageSyncPlayerTrailer;
import java.util.WeakHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="vehicle", value={Side.SERVER})
public class SyncedPlayerData {
    private static final WeakHashMap<EntityPlayer, Holder> PLAYER_DATA_MAP = new WeakHashMap();

    private static Holder getPlayerData(EntityPlayer player) {
        return PLAYER_DATA_MAP.computeIfAbsent(player, player1 -> new Holder());
    }

    public static int getTrailer(EntityPlayer player) {
        Holder holder = SyncedPlayerData.getPlayerData(player);
        if (holder != null) {
            return holder.getTrailer();
        }
        return -1;
    }

    public static void setTrailer(EntityPlayer player, int trailer) {
        Holder holder = SyncedPlayerData.getPlayerData(player);
        if (holder != null) {
            holder.setTrailer(trailer);
        }
        if (!player.field_70170_p.field_72995_K) {
            PacketHandler.INSTANCE.sendTo((IMessage)new MessageSyncPlayerTrailer(player.func_145782_y(), trailer), (EntityPlayerMP)player);
            PacketHandler.INSTANCE.sendToAllTracking((IMessage)new MessageSyncPlayerTrailer(player.func_145782_y(), trailer), (Entity)player);
        }
    }

    public static Optional<BlockPos> getGasPumpPos(EntityPlayer player) {
        Holder holder = SyncedPlayerData.getPlayerData(player);
        if (holder != null) {
            return holder.getGasPumpPos();
        }
        return Optional.absent();
    }

    public static void setGasPumpPos(EntityPlayer player, Optional<BlockPos> optional) {
        Holder holder = SyncedPlayerData.getPlayerData(player);
        if (holder != null) {
            holder.setGasPumpPos(optional);
        }
        if (!player.field_70170_p.field_72995_K) {
            PacketHandler.INSTANCE.sendTo((IMessage)new MessageSyncPlayerGasPumpPos(player.func_145782_y(), optional), (EntityPlayerMP)player);
            PacketHandler.INSTANCE.sendToAllTracking((IMessage)new MessageSyncPlayerGasPumpPos(player.func_145782_y(), optional), (Entity)player);
        }
    }

    @SubscribeEvent
    public void onStartTracking(PlayerEvent.StartTracking event) {
        EntityPlayer player;
        Holder holder;
        if (event.getTarget() instanceof EntityPlayer && (holder = SyncedPlayerData.getPlayerData(player = (EntityPlayer)event.getTarget())) != null) {
            PacketHandler.INSTANCE.sendTo((IMessage)new MessageSyncPlayerData(player.func_145782_y(), holder), (EntityPlayerMP)event.getEntityPlayer());
        }
    }

    @SubscribeEvent
    public void onPlayerJoinWorld(EntityJoinWorldEvent event) {
        EntityPlayer player;
        Holder holder;
        Entity entity = event.getEntity();
        if (entity instanceof EntityPlayer && !event.getWorld().field_72995_K && (holder = SyncedPlayerData.getPlayerData(player = (EntityPlayer)entity)) != null) {
            PacketHandler.INSTANCE.sendTo((IMessage)new MessageSyncPlayerData(player.func_145782_y(), holder), (EntityPlayerMP)player);
        }
    }

    public static class Holder {
        private int trailer = -1;
        private Optional<BlockPos> gasPumpPos = Optional.absent();

        public void setTrailer(int id) {
            this.trailer = id;
        }

        public int getTrailer() {
            return this.trailer;
        }

        public void setGasPumpPos(Optional<BlockPos> gasPumpPos) {
            this.gasPumpPos = gasPumpPos;
        }

        public Optional<BlockPos> getGasPumpPos() {
            return this.gasPumpPos;
        }
    }
}

