/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.entity.vehicle;

import com.mrcrayfish.vehicle.client.EntityRaytracer;
import com.mrcrayfish.vehicle.common.inventory.StorageInventory;
import com.mrcrayfish.vehicle.entity.EngineType;
import com.mrcrayfish.vehicle.entity.EntityLandVehicle;
import com.mrcrayfish.vehicle.entity.trailer.EntityStorageTrailer;
import com.mrcrayfish.vehicle.init.ModSounds;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityLawnMower
extends EntityLandVehicle
implements EntityRaytracer.IEntityRaytraceable {
    public EntityLawnMower(World worldIn) {
        super(worldIn);
        this.setMaxSpeed(8.0f);
        this.func_70105_a(1.2f, 1.0f);
        this.setFuelCapacity(5000.0f);
    }

    @Override
    public void updateVehicle() {
        super.updateVehicle();
        if (!this.field_70170_p.field_72995_K && this.func_184179_bs() != null) {
            AxisAlignedBB axisAligned = this.func_174813_aQ().func_186662_g(0.25);
            Vec3d lookVec = this.func_70040_Z().func_186678_a(0.5);
            int minX = MathHelper.func_76128_c((double)(axisAligned.field_72340_a + lookVec.field_72450_a));
            int maxX = MathHelper.func_76143_f((double)(axisAligned.field_72336_d + lookVec.field_72450_a));
            int minZ = MathHelper.func_76128_c((double)(axisAligned.field_72339_c + lookVec.field_72449_c));
            int maxZ = MathHelper.func_76143_f((double)(axisAligned.field_72334_f + lookVec.field_72449_c));
            for (int x = minX; x < maxX; ++x) {
                for (int z = minZ; z < maxZ; ++z) {
                    BlockPos pos = new BlockPos((double)x, axisAligned.field_72338_b + 0.5, (double)z);
                    IBlockState state = this.field_70170_p.func_180495_p(pos);
                    EntityStorageTrailer trailer = null;
                    if (this.getTrailer() instanceof EntityStorageTrailer) {
                        trailer = (EntityStorageTrailer)this.getTrailer();
                    }
                    if (!(state.func_177230_c() instanceof BlockBush)) continue;
                    NonNullList drops = NonNullList.func_191196_a();
                    state.func_177230_c().getDrops(drops, (IBlockAccess)this.field_70170_p, pos, state, 1);
                    for (ItemStack stack : drops) {
                        this.addItemToStorage(trailer, stack);
                    }
                    this.field_70170_p.func_175698_g(pos);
                    this.field_70170_p.func_184133_a(null, pos, state.func_177230_c().getSoundType(state, this.field_70170_p, pos, (Entity)this).func_185845_c(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                    this.field_70170_p.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
                }
            }
        }
    }

    private void addItemToStorage(EntityStorageTrailer storageTrailer, ItemStack stack) {
        if (stack.func_190926_b()) {
            return;
        }
        if (storageTrailer != null && storageTrailer.getInventory() != null) {
            StorageInventory storage = storageTrailer.getInventory();
            storage.addItemStack(stack);
            if (!stack.func_190926_b()) {
                if (storageTrailer.getTrailer() instanceof EntityStorageTrailer) {
                    this.addItemToStorage((EntityStorageTrailer)storageTrailer.getTrailer(), stack);
                } else {
                    this.spawnItemStack(this.field_70170_p, stack);
                }
            }
        } else {
            this.spawnItemStack(this.field_70170_p, stack);
        }
    }

    private void spawnItemStack(World worldIn, ItemStack stack) {
        while (!stack.func_190926_b()) {
            EntityItem entityItem = new EntityItem(worldIn, this.field_70169_q, this.field_70167_r, this.field_70166_s, stack.func_77979_a(this.field_70146_Z.nextInt(21) + 10));
            entityItem.func_174867_a(20);
            entityItem.field_70159_w = -this.field_70159_w / 4.0;
            entityItem.field_70181_x = this.field_70146_Z.nextGaussian() * (double)0.05f + (double)0.2f;
            entityItem.field_70179_y = -this.field_70179_y / 4.0;
            worldIn.func_72838_d((Entity)entityItem);
        }
    }

    @Override
    public SoundEvent getMovingSound() {
        return ModSounds.ATV_ENGINE_MONO;
    }

    @Override
    public SoundEvent getRidingSound() {
        return ModSounds.ATV_ENGINE_STEREO;
    }

    @Override
    public EngineType getEngineType() {
        return EngineType.SMALL_MOTOR;
    }

    @Override
    public boolean canBeColored() {
        return true;
    }

    @Override
    public boolean canTowTrailer() {
        return true;
    }

    @Override
    public boolean isLockable() {
        return false;
    }
}

