/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.network.message;

import com.mrcrayfish.vehicle.VehicleMod;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageEntityFluid
implements IMessage,
IMessageHandler<MessageEntityFluid, IMessage> {
    private int entityId;
    private FluidStack stack;

    public MessageEntityFluid() {
    }

    public MessageEntityFluid(int entityId, FluidStack stack) {
        this.entityId = entityId;
        this.stack = stack;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeBoolean(this.stack != null);
        if (this.stack != null) {
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.stack.writeToNBT(new NBTTagCompound()));
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = buf.readInt();
        if (buf.readBoolean()) {
            this.stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)ByteBufUtils.readTag((ByteBuf)buf));
        }
    }

    public IMessage onMessage(MessageEntityFluid message, MessageContext ctx) {
        FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> VehicleMod.proxy.syncEntityFluid(message.entityId, message.stack));
        return null;
    }
}

