/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.tileentity;

import com.mrcrayfish.vehicle.VehicleConfig;
import com.mrcrayfish.vehicle.block.BlockFluidPipe;
import com.mrcrayfish.vehicle.tileentity.TileFluidHandlerSynced;
import com.mrcrayfish.vehicle.util.FluidUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntityFluidPipe
extends TileFluidHandlerSynced
implements ITickable {
    protected int capacity = 500;
    protected int transferAmount;
    protected boolean[] disabledConnections;

    public TileEntityFluidPipe() {
        this.transferAmount = VehicleConfig.SERVER.pipeTransferAmount;
        this.tank = new FluidTank(this.capacity);
        this.disabledConnections = new boolean[EnumFacing.values().length];
    }

    public static boolean[] getDisabledConnections(TileEntityFluidPipe pipe) {
        return pipe != null ? pipe.getDisabledConnections() : new boolean[EnumFacing.values().length];
    }

    public boolean[] getDisabledConnections() {
        return this.disabledConnections;
    }

    public boolean isConnectionDisabled(int indexFacing) {
        return this.disabledConnections[indexFacing];
    }

    public boolean isConnectionDisabled(EnumFacing facing) {
        return this.disabledConnections[facing.func_176745_a()];
    }

    public void setConnectionDisabled(int indexFacing, boolean disabled) {
        this.disabledConnections[indexFacing] = disabled;
        this.syncToClient();
    }

    public void setConnectionDisabled(EnumFacing facing, boolean disabled) {
        this.setConnectionDisabled(facing.func_176745_a(), disabled);
    }

    public void func_73660_a() {
        if (this.tank.getFluid() == null) {
            return;
        }
        if (this.field_145850_b.func_175640_z(this.field_174879_c)) {
            return;
        }
        IFluidHandler handler = this.getConnectedFluidHandler((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockFluidPipe.FACING));
        if (handler != null) {
            FluidUtils.transferFluid((IFluidHandler)this.tank, handler, this.transferAmount);
        }
    }

    @Nullable
    protected IFluidHandler getConnectedFluidHandler(EnumFacing facing) {
        IFluidHandler handler;
        BlockPos adjacentPos = this.field_174879_c.func_177972_a(facing);
        TileEntity tileEntity = this.field_145850_b.func_175625_s(adjacentPos);
        if (tileEntity != null && (handler = (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d())) != null) {
            IBlockState adjacentState = this.field_145850_b.func_180495_p(adjacentPos);
            if ((adjacentState = adjacentState.func_185899_b((IBlockAccess)this.field_145850_b, adjacentPos)).func_177230_c() instanceof BlockFluidPipe && (!((Boolean)adjacentState.func_177229_b((IProperty)BlockFluidPipe.CONNECTED_PIPES[facing.func_176734_d().func_176745_a()])).booleanValue() || tileEntity instanceof TileEntityFluidPipe && ((TileEntityFluidPipe)tileEntity).isConnectionDisabled(facing.func_176734_d()))) {
                return null;
            }
            return handler;
        }
        List fluidEntities = this.field_145850_b.func_175647_a(Entity.class, new AxisAlignedBB(adjacentPos), entity -> entity != null && entity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null));
        if (!fluidEntities.isEmpty()) {
            return (IFluidHandler)((Entity)fluidEntities.get(0)).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound tag) {
        FluidUtils.fixEmptyTag(tag);
        super.func_145839_a(tag);
        byte[] byteArr = tag.func_74770_j("disabledConnections");
        for (int i = 0; i < byteArr.length; ++i) {
            this.disabledConnections[i] = byteArr[i] == 1;
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        byte[] byteArr = new byte[this.disabledConnections.length];
        for (int i = 0; i < byteArr.length; ++i) {
            byteArr[i] = (byte)(this.disabledConnections[i] ? 1 : 0);
        }
        tag.func_74773_a("disabledConnections", byteArr);
        return tag;
    }
}

