/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.blocks;

import com.mrcrayfish.furniture.api.Recipes;
import com.mrcrayfish.furniture.blocks.BlockFurnitureTile;
import com.mrcrayfish.furniture.init.FurnitureItems;
import com.mrcrayfish.furniture.tileentity.TileEntityChoppingBoard;
import com.mrcrayfish.furniture.util.CollisionHelper;
import com.mrcrayfish.furniture.util.TileEntityUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockChoppingBoard
extends BlockFurnitureTile {
    private static final AxisAlignedBB BOUNDING_BOX_ONE = CollisionHelper.getBlockBounds(EnumFacing.NORTH, 0.0, 0.0, 0.1875, 1.0, 0.09375, 0.8125);
    private static final AxisAlignedBB BOUNDING_BOX_TWO = CollisionHelper.getBlockBounds(EnumFacing.EAST, 0.0, 0.0, 0.1875, 1.0, 0.09375, 0.8125);
    private static final AxisAlignedBB COLLISION_BOX_ONE = CollisionHelper.getBlockBounds(EnumFacing.NORTH, 0.0, 0.0, 0.1875, 1.0, 0.0625, 0.8125);
    private static final AxisAlignedBB COLLISION_BOX_TWO = CollisionHelper.getBlockBounds(EnumFacing.EAST, 0.0, 0.0, 0.1875, 1.0, 0.0625, 0.8125);

    public BlockChoppingBoard(Material material) {
        super(material);
        this.func_149711_c(0.5f);
        this.func_149672_a(SoundType.field_185848_a);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = playerIn.func_184586_b(hand);
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileEntityChoppingBoard) {
            TileEntityChoppingBoard tileEntityChoppingBoard = (TileEntityChoppingBoard)tileEntity;
            if (!heldItem.func_190926_b()) {
                if (Recipes.getChoppingBoardRecipeFromInput(heldItem) != null) {
                    if (tileEntityChoppingBoard.getFood() == null) {
                        tileEntityChoppingBoard.setFood(new ItemStack(heldItem.func_77973_b(), 1, heldItem.func_77952_i()));
                        TileEntityUtil.markBlockForUpdate(worldIn, pos);
                        worldIn.func_175666_e(pos, (Block)this);
                        heldItem.func_190918_g(1);
                        return true;
                    }
                    if (!worldIn.field_72995_K) {
                        EntityItem entityFood = new EntityItem(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.4, (double)pos.func_177952_p() + 0.5, tileEntityChoppingBoard.getFood());
                        worldIn.func_72838_d((Entity)entityFood);
                        tileEntityChoppingBoard.setFood(null);
                        TileEntityUtil.markBlockForUpdate(worldIn, pos);
                    }
                    worldIn.func_175666_e(pos, (Block)this);
                    return true;
                }
                if (heldItem.func_77973_b() == FurnitureItems.KNIFE && tileEntityChoppingBoard.getFood() != null) {
                    if (tileEntityChoppingBoard.chopFood()) {
                        heldItem.func_77972_a(1, (EntityLivingBase)playerIn);
                    }
                    return true;
                }
            }
            if (tileEntityChoppingBoard.getFood() != null) {
                if (!worldIn.field_72995_K) {
                    EntityItem entityFood = new EntityItem(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.4, (double)pos.func_177952_p() + 0.5, tileEntityChoppingBoard.getFood());
                    worldIn.func_72838_d((Entity)entityFood);
                }
                tileEntityChoppingBoard.setFood(null);
                TileEntityUtil.markBlockForUpdate(worldIn, pos);
                worldIn.func_175666_e(pos, (Block)this);
            }
        }
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (this.func_176201_c(state) % 2 == 1) {
            return BOUNDING_BOX_ONE;
        }
        return BOUNDING_BOX_TWO;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean p_185477_7_) {
        if (this.func_176201_c(state) % 2 == 1) {
            BlockChoppingBoard.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)COLLISION_BOX_ONE);
            return;
        }
        BlockChoppingBoard.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)COLLISION_BOX_TWO);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityChoppingBoard();
    }

    @Override
    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        if (world.func_175625_s(pos) instanceof TileEntityChoppingBoard) {
            TileEntityChoppingBoard tecb = (TileEntityChoppingBoard)world.func_175625_s(pos);
            return tecb.getFood() != null ? 1 : 0;
        }
        return 0;
    }
}

