/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.blocks;

import com.google.common.collect.Lists;
import com.mrcrayfish.furniture.MrCrayfishFurnitureMod;
import com.mrcrayfish.furniture.advancement.Triggers;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockTable
extends Block {
    public static final PropertyBool BACK = PropertyBool.func_177716_a((String)"back");
    public static final PropertyBool FORWARD = PropertyBool.func_177716_a((String)"forward");
    public static final PropertyBool LEFT = PropertyBool.func_177716_a((String)"left");
    public static final PropertyBool RIGHT = PropertyBool.func_177716_a((String)"right");
    public static final AxisAlignedBB EMPTY_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public static final AxisAlignedBB TOP = new AxisAlignedBB(0.0, 0.90625, 0.0, 1.0, 1.0, 1.0);
    public static final AxisAlignedBB SINGLE_LEG = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.90625, 0.625);
    public static final AxisAlignedBB[] ONE_AXIS_LEG = new AxisAlignedBB[]{new AxisAlignedBB(0.375, 0.0, 0.5625, 0.625, 0.90625, 0.8125), new AxisAlignedBB(0.5625, 0.0, 0.375, 0.8125, 0.90625, 0.625), new AxisAlignedBB(0.375, 0.0, 0.1875, 0.625, 0.90625, 0.4375), new AxisAlignedBB(0.1875, 0.0, 0.375, 0.4375, 0.90625, 0.625)};
    public static final AxisAlignedBB TWO_AXIS_NORTH_EAST = new AxisAlignedBB(0.1875, 0.0, 0.5625, 0.4375, 0.90625, 0.8125);
    public static final AxisAlignedBB TWO_AXIS_SOUTH_EAST = new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.4375, 0.90625, 0.4375);
    public static final AxisAlignedBB TWO_AXIS_NORTH_WEST = new AxisAlignedBB(0.5625, 0.0, 0.5625, 0.8125, 0.90625, 0.8125);
    public static final AxisAlignedBB TWO_AXIS_SOUTH_WEST = new AxisAlignedBB(0.5625, 0.0, 0.1875, 0.8125, 0.90625, 0.4375);

    public BlockTable(Material material, SoundType sound) {
        super(material);
        this.func_149711_c(1.0f);
        this.func_149672_a(sound);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BACK, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)FORWARD, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)LEFT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)RIGHT, (Comparable)Boolean.valueOf(false)));
        this.func_149647_a(MrCrayfishFurnitureMod.tabFurniture);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (placer instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)placer;
            Triggers.trigger(Triggers.PLACE_TABLE, player);
            Triggers.trigger(Triggers.PLACE_CHAIR_OR_TABLE, player);
        }
        super.func_180633_a(world, pos, state, placer, stack);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return false;
    }

    public boolean isSideSolid(IBlockState baseState, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.UP;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        boolean back = world.func_180495_p(pos.func_177968_d()).func_177230_c() == this;
        boolean forward = world.func_180495_p(pos.func_177978_c()).func_177230_c() == this;
        boolean left = world.func_180495_p(pos.func_177976_e()).func_177230_c() == this;
        boolean right = world.func_180495_p(pos.func_177974_f()).func_177230_c() == this;
        return state.func_177226_a((IProperty)BACK, (Comparable)Boolean.valueOf(back)).func_177226_a((IProperty)FORWARD, (Comparable)Boolean.valueOf(forward)).func_177226_a((IProperty)LEFT, (Comparable)Boolean.valueOf(left)).func_177226_a((IProperty)RIGHT, (Comparable)Boolean.valueOf(right));
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BACK, FORWARD, LEFT, RIGHT});
    }

    protected List<AxisAlignedBB> getCollisionBoxList(IBlockState state, World world, BlockPos pos) {
        boolean west;
        boolean east;
        boolean south;
        ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
        IBlockState actualState = this.func_176221_a(state, (IBlockAccess)world, pos);
        boolean north = (Boolean)actualState.func_177229_b((IProperty)FORWARD);
        int connectedSides = (north ? 1 : 0) + ((south = ((Boolean)actualState.func_177229_b((IProperty)BACK)).booleanValue()) ? 1 : 0) + ((east = ((Boolean)actualState.func_177229_b((IProperty)RIGHT)).booleanValue()) ? 1 : 0) + ((west = ((Boolean)actualState.func_177229_b((IProperty)LEFT)).booleanValue()) ? 1 : 0);
        if (connectedSides == 0) {
            boxes.add(SINGLE_LEG);
        } else if (connectedSides >= 3 || north && south || east && west) {
            boxes.add(EMPTY_AABB);
        } else {
            if (north && east) {
                boxes.add(TWO_AXIS_NORTH_EAST);
            }
            if (south && east) {
                boxes.add(TWO_AXIS_SOUTH_EAST);
            }
            if (north && west) {
                boxes.add(TWO_AXIS_NORTH_WEST);
            }
            if (south && west) {
                boxes.add(TWO_AXIS_SOUTH_WEST);
            }
            if (connectedSides == 1) {
                int connectedIndex;
                int n = north ? 0 : (east ? 3 : (south ? 2 : (connectedIndex = west ? 1 : -1)));
                if (connectedIndex >= 0) {
                    boxes.add(ONE_AXIS_LEG[connectedIndex]);
                }
            }
        }
        boxes.add(TOP);
        return boxes;
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean p_185477_7_) {
        List<AxisAlignedBB> list = this.getCollisionBoxList(this.func_176221_a(state, (IBlockAccess)world, pos), world, pos);
        for (AxisAlignedBB box : list) {
            BlockTable.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)box);
        }
    }

    public RayTraceResult func_180636_a(IBlockState blockState, World world, BlockPos pos, Vec3d start, Vec3d end) {
        ArrayList list = Lists.newArrayList();
        for (AxisAlignedBB axisalignedbb : this.getCollisionBoxList(this.func_176221_a(blockState, (IBlockAccess)world, pos), world, pos)) {
            list.add(this.func_185503_a(pos, start, end, axisalignedbb));
        }
        RayTraceResult raytraceresult1 = null;
        double d1 = 0.0;
        for (RayTraceResult raytraceresult : list) {
            double d0;
            if (raytraceresult == null || !((d0 = raytraceresult.field_72307_f.func_72436_e(end)) > d1)) continue;
            raytraceresult1 = raytraceresult;
            d1 = d0;
        }
        return raytraceresult1;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_185481_k(IBlockState state) {
        return true;
    }
}

