/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.tileentity;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.mrcrayfish.furniture.blocks.BlockAbstractTV;
import com.mrcrayfish.furniture.client.DownloadUtils;
import com.mrcrayfish.furniture.client.GifCache;
import com.mrcrayfish.furniture.client.GifDownloadThread;
import com.mrcrayfish.furniture.tileentity.IValueContainer;
import com.mrcrayfish.furniture.tileentity.TileEntitySyncClient;
import com.mrcrayfish.furniture.util.TileEntityUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityTV
extends TileEntitySyncClient
implements IValueContainer {
    private int width;
    private int height;
    private double screenYOffset;
    private double screenZOffset;
    private boolean stretch;
    private boolean powered;
    private boolean disabled;
    private List<String> channels = new ArrayList<String>();
    private int currentChannel;
    @SideOnly(value=Side.CLIENT)
    private boolean loading;
    @SideOnly(value=Side.CLIENT)
    private boolean loaded;
    @SideOnly(value=Side.CLIENT)
    private GifDownloadThread.ImageDownloadResult result;

    public TileEntityTV() {
    }

    public TileEntityTV(int width, int height, double screenYOffset, double screenZOffset) {
        this.width = width;
        this.height = height;
        this.screenYOffset = screenYOffset;
        this.screenZOffset = screenZOffset;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        NBTTagList channelList = new NBTTagList();
        this.channels.forEach(url -> channelList.func_74742_a((NBTBase)new NBTTagString(url)));
        compound.func_74782_a("Channels", (NBTBase)channelList);
        compound.func_74768_a("CurrentChannel", this.currentChannel);
        compound.func_74757_a("Stretch", this.stretch);
        compound.func_74757_a("Powered", this.powered);
        compound.func_74757_a("DisableInteraction", this.disabled);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.channels.clear();
        if (compound.func_150297_b("Channels", 9)) {
            NBTTagList channelList = compound.func_150295_c("Channels", 8);
            channelList.forEach(nbtBase -> {
                if (nbtBase instanceof NBTTagString) {
                    NBTTagString url = (NBTTagString)nbtBase;
                    this.channels.add(url.func_150285_a_());
                }
            });
        } else if (compound.func_150297_b("URL", 8)) {
            this.channels.add(compound.func_74779_i("URL"));
        }
        if (compound.func_150297_b("CurrentChannel", 3)) {
            this.currentChannel = compound.func_74762_e("CurrentChannel");
        }
        if (compound.func_150297_b("Stretch", 1)) {
            this.stretch = compound.func_74767_n("Stretch");
        }
        if (compound.func_150297_b("Powered", 1)) {
            this.powered = compound.func_74767_n("Powered");
        }
        if (compound.func_150297_b("DisableInteraction", 1)) {
            this.disabled = compound.func_74767_n("DisableInteraction");
        }
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K && this.powered && this.channels.size() > 0 && this.currentChannel >= 0 && this.currentChannel < this.channels.size()) {
            this.loadUrl(this.channels.get(this.currentChannel));
        }
    }

    @Nullable
    public String getCurrentChannel() {
        if (this.channels.size() > 0 && this.currentChannel >= 0 && this.currentChannel < this.channels.size()) {
            return this.channels.get(this.currentChannel);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void loadUrl(String url) {
        if (this.loading) {
            return;
        }
        URI uri = DownloadUtils.createUri(url);
        if (uri == null) {
            this.result = GifDownloadThread.ImageDownloadResult.INVALID_URL;
            this.loaded = true;
            return;
        }
        if (!DownloadUtils.isValidScheme(uri)) {
            this.result = GifDownloadThread.ImageDownloadResult.WRONG_SCHEME;
            this.loaded = true;
            return;
        }
        if (!DownloadUtils.isValidType(uri, "gif")) {
            this.result = GifDownloadThread.ImageDownloadResult.UNSUPPORTED_FILE_TYPE;
            this.loaded = true;
            return;
        }
        if (!DownloadUtils.isTrustedDomain(uri)) {
            this.result = GifDownloadThread.ImageDownloadResult.UNTRUSTED;
            this.loaded = true;
            return;
        }
        this.loaded = false;
        this.result = null;
        if (!GifCache.INSTANCE.loadCached(url)) {
            this.loading = true;
            new GifDownloadThread(uri, (result, message) -> {
                this.loading = false;
                this.result = result;
                if (result == GifDownloadThread.ImageDownloadResult.SUCCESS) {
                    this.loaded = true;
                }
            }).start();
        } else {
            this.loaded = true;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isLoading() {
        return this.loading;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isLoaded() {
        return this.loaded && !this.loading;
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public GifDownloadThread.ImageDownloadResult getResult() {
        return this.result;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public double getScreenYOffset() {
        return this.screenYOffset;
    }

    public double getScreenZOffset() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() instanceof BlockAbstractTV) {
            return ((BlockAbstractTV)state.func_177230_c()).getScreenZOffset(state);
        }
        return this.screenZOffset;
    }

    @Override
    public List<IValueContainer.Entry> getEntries() {
        ArrayList entries = Lists.newArrayList();
        for (int i = 0; i < 3; ++i) {
            String url = "";
            if (this.channels.size() > 0 && i < this.channels.size()) {
                url = this.channels.get(i);
            }
            entries.add(new IValueContainer.Entry("channel_" + i, "Channel #" + (i + 1), IValueContainer.Entry.Type.TEXT_FIELD, url));
        }
        entries.add(new IValueContainer.Entry("stretch", "Stretch to Screen", IValueContainer.Entry.Type.TOGGLE, this.stretch));
        entries.add(new IValueContainer.Entry("powered", "Powered", IValueContainer.Entry.Type.TOGGLE, this.powered));
        return entries;
    }

    @Override
    public String updateEntries(Map<String, String> entries, EntityPlayer player) {
        this.channels.clear();
        for (int i = 0; i < 3; ++i) {
            String url = entries.get("channel_" + i);
            if (Strings.isNullOrEmpty((String)url)) continue;
            this.channels.add(url);
        }
        this.stretch = Boolean.valueOf(entries.get("stretch"));
        this.powered = Boolean.valueOf(entries.get("powered"));
        this.func_70296_d();
        return null;
    }

    @Override
    public boolean requiresTool() {
        return false;
    }

    public boolean isStretched() {
        return this.stretch;
    }

    @Override
    public BlockPos getContainerPos() {
        return this.field_174879_c;
    }

    public void setPowered(boolean powered) {
        if (!this.disabled) {
            this.powered = powered;
            TileEntityUtil.syncToClient(this);
        }
    }

    public boolean isPowered() {
        return this.powered;
    }

    public boolean nextChannel() {
        if (!this.disabled && this.powered && this.channels.size() > 1) {
            ++this.currentChannel;
            if (this.currentChannel >= this.channels.size()) {
                this.currentChannel = 0;
            }
            TileEntityUtil.syncToClient(this);
            return true;
        }
        return false;
    }

    public boolean isDisabled() {
        return this.disabled;
    }
}

