/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.network;

import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import javax.annotation.Nullable;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.impl.ConfigHandler;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageServerPing
implements IMessage {
    public Map<String, Boolean> forcedKeys = Maps.newHashMap();

    public MessageServerPing() {
    }

    public MessageServerPing(@Nullable Map<String, Boolean> forcedKeys) {
        if (forcedKeys != null) {
            this.forcedKeys = forcedKeys;
            return;
        }
        ConfigCategory serverForcing = ConfigHandler.instance().config.getCategory("server_forcing");
        for (String key : serverForcing.keySet()) {
            if (!serverForcing.get(key).getBoolean(false)) continue;
            this.forcedKeys.put(key, ConfigHandler.instance().getConfig(key));
        }
    }

    public void fromBytes(ByteBuf buf) {
        int amount = buf.readInt();
        for (int i = 0; i < amount; ++i) {
            this.forcedKeys.put(ByteBufUtils.readUTF8String((ByteBuf)buf), buf.readBoolean());
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.forcedKeys.size());
        for (Map.Entry<String, Boolean> entry : this.forcedKeys.entrySet()) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)entry.getKey());
            buf.writeBoolean(entry.getValue().booleanValue());
        }
    }

    public static class Handler
    implements IMessageHandler<MessageServerPing, IMessage> {
        public IMessage onMessage(MessageServerPing message, MessageContext ctx) {
            Waila.LOGGER.info("Received server authentication msg. Remote sync will be activated");
            Waila.instance.serverPresent = true;
            for (String key : message.forcedKeys.keySet()) {
                Waila.LOGGER.info("Received forced key config {} : {}", (Object)key, (Object)message.forcedKeys.get(key));
            }
            ConfigHandler.instance().forcedConfigs = message.forcedKeys;
            return null;
        }
    }
}

