/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.client.gui;

import com.mumfrey.liteloader.LiteMod;
import com.mumfrey.liteloader.api.BrandingProvider;
import com.mumfrey.liteloader.api.LiteAPI;
import com.mumfrey.liteloader.api.ModInfoDecorator;
import com.mumfrey.liteloader.client.api.LiteLoaderBrandingProvider;
import com.mumfrey.liteloader.client.gui.GuiHoverLabel;
import com.mumfrey.liteloader.client.gui.GuiPanel;
import com.mumfrey.liteloader.client.gui.GuiPanelAbout;
import com.mumfrey.liteloader.client.gui.GuiPanelConfigContainer;
import com.mumfrey.liteloader.client.gui.GuiPanelError;
import com.mumfrey.liteloader.client.gui.GuiPanelLiteLoaderLog;
import com.mumfrey.liteloader.client.gui.GuiPanelMods;
import com.mumfrey.liteloader.client.gui.GuiPanelSettings;
import com.mumfrey.liteloader.client.gui.GuiPanelUpdateCheck;
import com.mumfrey.liteloader.core.LiteLoader;
import com.mumfrey.liteloader.core.LiteLoaderMods;
import com.mumfrey.liteloader.core.LiteLoaderVersion;
import com.mumfrey.liteloader.core.ModInfo;
import com.mumfrey.liteloader.core.api.LiteLoaderCoreAPI;
import com.mumfrey.liteloader.gl.GL;
import com.mumfrey.liteloader.launch.LoaderEnvironment;
import com.mumfrey.liteloader.launch.LoaderProperties;
import com.mumfrey.liteloader.modconfig.ConfigManager;
import com.mumfrey.liteloader.modconfig.ConfigPanel;
import com.mumfrey.liteloader.util.render.Icon;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiLiteLoaderPanel
extends blk {
    static final int WHITE = -1;
    static final int OPAQUE = -16777216;
    static final int NOTIFICATION_TOOLTIP_FOREGROUND = 0xFFFFFF;
    static final int NOTIFICATION_TOOLTIP_BACKGROUND = -1342177127;
    static final int ERROR_TOOLTIP_FOREGROUND = 0xFF5555;
    static final int ERROR_TOOLTIP_BACKGROUND = -1338834944;
    static final int HEADER_HR_COLOUR = -6710887;
    static final int HEADER_TEXT_COLOUR = -1;
    static final int HEADER_TEXT_COLOUR_SUB = -5592406;
    static final int TOOLTIP_FOREGROUND = 0xFFFFFF;
    static final int TOOLTIP_FOREGROUND_SUB = 0xCCCCCC;
    static final int TOOLTIP_BACKGROUND = -1342177280;
    static final int LEFT_EDGE = 80;
    static final int MARGIN = 12;
    static final int TAB_WIDTH = 20;
    static final int TAB_HEIGHT = 40;
    static final int TAB_TOP = 20;
    static final int PANEL_TOP = 83;
    static final int PANEL_BOTTOM = 26;
    private static final double TWEEN_RATE = 0.08;
    private static boolean displayErrorToolTip = true;
    private blk parentScreen;
    private final LoaderEnvironment environment;
    private final LoaderProperties properties;
    private long tickNumber;
    private double lastTick;
    private double tweenAmount = 0.0;
    private boolean mouseDown;
    private boolean toggled;
    private boolean toggleable;
    private float tabOpacity = 0.0f;
    private boolean showTab = true;
    private String activeModText;
    private String versionText;
    private GuiPanel currentPanel;
    private final GuiPanelMods modsPanel;
    private final GuiPanelSettings settingsPanel;
    private int brandColour = -12089903;
    private nf logoResource = LiteLoaderBrandingProvider.ABOUT_TEXTURE;
    private Icon logoCoords = LiteLoaderBrandingProvider.LOGO_COORDS;
    private nf iconResource = LiteLoaderBrandingProvider.ABOUT_TEXTURE;
    private Icon iconCoords = LiteLoaderBrandingProvider.ICON_COORDS;
    private List<ModInfoDecorator> modInfoDecorators = new ArrayList<ModInfoDecorator>();
    private boolean mouseOverLogo = false;
    private int startupErrorCount = 0;
    private int criticalErrorCount = 0;
    private String notification;
    private boolean isSnapshot;

    public GuiLiteLoaderPanel(bib minecraft, blk parentScreen, LiteLoaderMods mods, LoaderEnvironment environment, LoaderProperties properties, ConfigManager configManager, boolean showTab) {
        this.j = minecraft;
        this.q = minecraft.k;
        this.parentScreen = parentScreen;
        this.showTab = showTab;
        this.environment = environment;
        this.properties = properties;
        this.toggleable = true;
        this.versionText = cey.a((String)"gui.about.versiontext", (Object[])new Object[]{LiteLoader.getVersion()});
        this.activeModText = cey.a((String)"gui.about.modsloaded", (Object[])new Object[]{LiteLoader.getLoadedModsCount()});
        this.initBranding();
        this.modsPanel = new GuiPanelMods(this, minecraft, mods, environment, configManager, this.brandColour, this.modInfoDecorators);
        this.currentPanel = this.modsPanel;
        this.settingsPanel = new GuiPanelSettings(this, minecraft);
        this.startupErrorCount = mods.getStartupErrorCount();
        this.criticalErrorCount = mods.getCriticalErrorCount();
        this.isSnapshot = LiteLoader.isSnapshot();
        if (this.isSnapshot) {
            this.versionText = "\u00a7c" + LiteLoader.getBranding();
        }
    }

    private void initBranding() {
        Object logoProvider = null;
        int brandingColourProviderPriority = Integer.MIN_VALUE;
        int logoProviderPriority = Integer.MIN_VALUE;
        int iconProviderPriority = Integer.MIN_VALUE;
        for (LiteAPI api : LiteLoader.getAPIs()) {
            ModInfoDecorator modInfoDecorator;
            BrandingProvider brandingProvider = LiteLoader.getCustomisationProvider(api, BrandingProvider.class);
            if (brandingProvider != null) {
                if (brandingProvider.getBrandingColour() != 0 && brandingProvider.getPriority() > brandingColourProviderPriority) {
                    brandingColourProviderPriority = brandingProvider.getPriority();
                    this.brandColour = 0xFF000000 | brandingProvider.getBrandingColour();
                }
                nf logoResource = brandingProvider.getLogoResource();
                Icon logoCoords = brandingProvider.getLogoCoords();
                if (logoResource != null && logoCoords != null && brandingProvider.getPriority() > logoProviderPriority) {
                    logoProvider = api;
                    logoProviderPriority = brandingProvider.getPriority();
                    this.logoResource = logoResource;
                    this.logoCoords = logoCoords;
                }
                nf iconResource = brandingProvider.getIconResource();
                Icon iconCoords = brandingProvider.getIconCoords();
                if (iconResource != null && iconCoords != null && brandingProvider.getPriority() > iconProviderPriority) {
                    iconProviderPriority = brandingProvider.getPriority();
                    this.iconResource = iconResource;
                    this.iconCoords = iconCoords;
                }
            }
            if ((modInfoDecorator = LiteLoader.getCustomisationProvider(api, ModInfoDecorator.class)) == null) continue;
            this.modInfoDecorators.add(modInfoDecorator);
        }
        if (logoProvider != null && !LiteLoaderCoreAPI.class.isAssignableFrom(logoProvider.getClass())) {
            this.versionText = cey.a((String)"gui.about.poweredbyversion", (Object[])new Object[]{logoProvider.getVersion(), LiteLoader.getVersion()});
        }
    }

    public int getBrandColour() {
        return this.brandColour;
    }

    public void release() {
        this.parentScreen = null;
    }

    public blk getScreen() {
        return this.parentScreen;
    }

    public boolean isOpen() {
        return this.tweenAmount > 0.0;
    }

    public void setToggleable(boolean toggleable) {
        this.toggleable = toggleable;
    }

    public void setNotification(String notification) {
        this.notification = notification;
    }

    public void b() {
        displayErrorToolTip = false;
        this.currentPanel.setSize(this.l - 80, this.m);
        this.n.add(new GuiHoverLabel(2, 92, this.m - 26 + 9, this.q, cey.a((String)"gui.about.taboptions", (Object[])new Object[0]), this.brandColour));
        if (LiteLoaderVersion.getUpdateSite().canCheckForUpdate() && this.j.f == null && !this.isSnapshot) {
            this.n.add(new GuiHoverLabel(3, 130 + this.q.a(this.versionText) + 6, 50, this.q, cey.a((String)"gui.about.checkupdates", (Object[])new Object[0]), this.brandColour));
        }
        Keyboard.enableRepeatEvents((boolean)true);
    }

    public void m() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void a(bib minecraft, int width, int height) {
        if (this.j.m == this) {
            this.parentScreen.a(minecraft, width, height);
        }
        super.a(minecraft, width, height);
    }

    public void e() {
        this.currentPanel.onTick();
        ++this.tickNumber;
        if (this.j.m == this) {
            this.j.m = this.parentScreen;
            this.parentScreen.e();
            this.j.m = this;
        }
        if (this.toggled && this.toggleable) {
            this.onToggled();
        }
    }

    public void a(int mouseX, int mouseY, float partialTicks) {
        this.drawScreen(mouseX, mouseY, partialTicks, false);
    }

    public void drawScreen(int mouseX, int mouseY, float partialTicks, boolean alwaysExpandTab) {
        boolean active;
        boolean bl2 = active = this.j.m == this;
        if (active) {
            GL.glClear(256);
            this.parentScreen.a(-10, -10, partialTicks);
            GL.glClear(256);
        } else {
            this.l = this.parentScreen.l;
            this.m = this.parentScreen.m;
        }
        float xOffset = (float)(this.l - 80) * this.calcTween(partialTicks, active) + 16.0f + this.tabOpacity * -32.0f;
        int offsetMouseX = mouseX - (int)xOffset;
        boolean mouseOverTab = this.showTab && offsetMouseX > 60 && offsetMouseX < 80 && mouseY > 20 && mouseY < 60;
        this.handleMouseClick(offsetMouseX, mouseY, partialTicks, active, mouseOverTab);
        this.tabOpacity = mouseOverTab || alwaysExpandTab || this.startupErrorCount > 0 || this.notification != null || this.isOpen() ? 0.5f : Math.max(0.0f, this.tabOpacity - partialTicks * 0.1f);
        this.drawPanel(offsetMouseX, mouseY, partialTicks, active, xOffset);
        this.drawTooltips(mouseX, mouseY, partialTicks, active, xOffset, mouseOverTab);
    }

    private void drawPanel(int mouseX, int mouseY, float partialTicks, boolean active, float xOffset) {
        this.mouseOverLogo = false;
        GL.glBlendFuncSeparate(770, 771, 1, 0);
        GL.glPushMatrix();
        GL.glTranslatef(xOffset, 0.0f, 0.0f);
        GuiLiteLoaderPanel.a((int)80, (int)0, (int)this.l, (int)this.m, (int)-1342177280);
        if (this.showTab) {
            GuiLiteLoaderPanel.a((int)80, (int)0, (int)81, (int)20, (int)-1);
            GuiLiteLoaderPanel.a((int)80, (int)60, (int)81, (int)this.m, (int)-1);
            this.j.N().a(LiteLoaderBrandingProvider.ABOUT_TEXTURE);
            GuiLiteLoaderPanel.glDrawTexturedRect(60, 20, 21, 40, 80, 80, 122, 160, 0.5f + this.tabOpacity);
            if (this.startupErrorCount > 0) {
                GuiLiteLoaderPanel.glDrawTexturedRect(67, 22, 12, 12, 134, 92, 146, 104, 0.5f + this.tabOpacity);
            } else if (this.notification != null) {
                GuiLiteLoaderPanel.glDrawTexturedRect(67, 22, 12, 12, 146, 92, 158, 104, 0.5f + this.tabOpacity);
            }
        } else {
            GuiLiteLoaderPanel.a((int)80, (int)0, (int)81, (int)this.m, (int)-1);
        }
        if (this.isOpen()) {
            if (this.currentPanel.isCloseRequested()) {
                this.closeCurrentPanel();
            }
            this.drawCurrentPanel(mouseX, mouseY, partialTicks);
            if (!this.currentPanel.stealFocus()) {
                super.a(mouseX, mouseY, partialTicks);
            }
        } else {
            this.closeCurrentPanel();
        }
        GL.glPopMatrix();
    }

    private void drawCurrentPanel(int mouseX, int mouseY, float partialTicks) {
        GL.glPushMatrix();
        GL.glTranslatef(80.0f, 0.0f, 0.0f);
        this.currentPanel.draw(mouseX - 80, mouseY, partialTicks);
        GL.glPopMatrix();
    }

    protected boolean drawInfoPanel(int mouseX, int mouseY, float partialTicks, int left, int bottom) {
        int right = this.l - 12 - 80 + left;
        this.j.N().a(this.logoResource);
        GuiLiteLoaderPanel.glDrawTexturedRect(left += 12, 12, this.logoCoords, 1.0f);
        this.j.N().a(this.iconResource);
        GuiLiteLoaderPanel.glDrawTexturedRect(right - this.iconCoords.getIconWidth(), 12, this.iconCoords, 1.0f);
        this.q.a(this.versionText, left + 38, 50, -1);
        this.q.a(this.activeModText, left + 38, 60, -5592406);
        GuiLiteLoaderPanel.a((int)left, (int)80, (int)right, (int)81, (int)-6710887);
        GuiLiteLoaderPanel.a((int)left, (int)(this.m - bottom + 2), (int)right, (int)(this.m - bottom + 3), (int)-6710887);
        this.mouseOverLogo = mouseY > 12 && mouseY < 12 + this.logoCoords.getIconHeight() && mouseX > left && mouseX < left + this.logoCoords.getIconWidth();
        return this.mouseOverLogo;
    }

    private void drawTooltips(int mouseX, int mouseY, float partialTicks, boolean active, float xOffset, boolean mouseOverTab) {
        boolean annoyingTip;
        boolean bl2 = annoyingTip = this.startupErrorCount > 0 || this.notification != null;
        if (mouseOverTab && this.tweenAmount < 0.01) {
            GuiLiteLoaderPanel.drawTooltip(this.q, LiteLoader.getVersionDisplayString(), mouseX, mouseY, this.l, this.m, 0xFFFFFF, -1342177280);
            GuiLiteLoaderPanel.drawTooltip(this.q, this.activeModText, mouseX, mouseY + 13, this.l, this.m, 0xCCCCCC, -1342177280);
            if (annoyingTip) {
                displayErrorToolTip = false;
                this.drawNotificationTooltip(mouseX, mouseY - 13);
            }
        } else if (displayErrorToolTip && annoyingTip && !active && this.parentScreen instanceof blr) {
            this.drawNotificationTooltip((int)xOffset + 80 - 12, 22);
        }
    }

    private void drawNotificationTooltip(int left, int top) {
        if (this.startupErrorCount > 0) {
            GuiLiteLoaderPanel.drawTooltip(this.q, cey.a((String)"gui.error.tooltip", (Object[])new Object[]{this.startupErrorCount, this.criticalErrorCount}), left, top, this.l, this.m, 0xFF5555, -1338834944);
        } else if (this.notification != null) {
            boolean isCritical = this.notification.startsWith("!!");
            String text = isCritical ? this.notification.substring(2) : this.notification;
            int bgColour = isCritical ? -1338834944 : -1342177127;
            GuiLiteLoaderPanel.drawTooltip(this.q, text, left, top, this.l, this.m, 0xFFFFFF, bgColour);
        }
    }

    protected void a(bja button) {
        if (button.k == 2) {
            this.setCurrentPanel(this.settingsPanel);
        }
        if (button.k == 3) {
            this.setCurrentPanel(new GuiPanelUpdateCheck(this, this.j, LiteLoaderVersion.getUpdateSite(), "LiteLoader", this.properties));
        }
    }

    protected void a(char keyChar, int keyCode) {
        this.currentPanel.keyPressed(keyChar, keyCode);
    }

    void showLogPanel() {
        this.setCurrentPanel(new GuiPanelLiteLoaderLog(this.j, this));
    }

    void showAboutPanel() {
        this.setCurrentPanel(new GuiPanelAbout(this.j, this));
    }

    public void showErrorPanel(ModInfo<?> mod) {
        this.setCurrentPanel(new GuiPanelError(this.j, this, mod));
    }

    protected void a(int mouseX, int mouseY, int button) throws IOException {
        this.currentPanel.mousePressed(mouseX - 80, mouseY, button);
        if (button == 0 && this.mouseOverLogo && !this.currentPanel.stealFocus()) {
            this.showAboutPanel();
        }
        if (!this.currentPanel.stealFocus()) {
            super.a(mouseX, mouseY, button);
        }
    }

    protected void b(int mouseX, int mouseY, int button) {
        if (button == -1) {
            this.currentPanel.mouseMoved(mouseX - 80, mouseY);
        } else {
            this.currentPanel.mouseReleased(mouseX - 80, mouseY, button);
        }
        if (!this.currentPanel.stealFocus()) {
            super.b(mouseX, mouseY, button);
        }
    }

    public void k() throws IOException {
        int mouseWheelDelta = Mouse.getEventDWheel();
        if (mouseWheelDelta != 0) {
            this.currentPanel.mouseWheelScrolled(mouseWheelDelta);
        }
        super.k();
    }

    public void handleMouseClick(int mouseX, int mouseY, float partialTicks, boolean active, boolean mouseOverTab) {
        boolean mouseDown = Mouse.isButtonDown((int)0);
        if ((active && mouseX < 80 && this.tweenAmount > 0.75 || mouseOverTab) && !this.mouseDown && mouseDown) {
            this.mouseDown = true;
            this.toggled = true;
        } else if (this.mouseDown && !mouseDown) {
            this.mouseDown = false;
        }
    }

    private float calcTween(float partialTicks, boolean active) {
        double tickValue = (float)this.tickNumber + partialTicks;
        if (active && this.tweenAmount < 1.0) {
            this.tweenAmount = Math.min(1.0, this.tweenAmount + (tickValue - this.lastTick) * 0.08);
        } else if (!active && this.isOpen()) {
            this.tweenAmount = Math.max(0.0, this.tweenAmount - (tickValue - this.lastTick) * 0.08);
        }
        this.lastTick = tickValue;
        return 1.0f - (float)Math.sin(this.tweenAmount * 0.5 * Math.PI);
    }

    void onToggled() {
        this.toggled = false;
        this.j.a((blk)(this.j.m == this ? this.parentScreen : this));
    }

    void openConfigPanel(ConfigPanel panel, LiteMod mod) {
        if (panel != null) {
            this.setCurrentPanel(new GuiPanelConfigContainer(this.j, panel, mod));
        }
    }

    private void setCurrentPanel(GuiPanel newPanel) {
        this.closeCurrentPanel();
        this.currentPanel = newPanel;
        this.currentPanel.setSize(this.l - 80, this.m);
        this.currentPanel.onShown();
    }

    private void closeCurrentPanel() {
        this.currentPanel.onHidden();
        this.currentPanel = this.modsPanel;
        this.modsPanel.setSize(this.l - 80, this.m);
    }

    public static void drawTooltip(bip fontRenderer, String text, int left, int top, int screenWidth, int screenHeight, int colour, int backgroundColour) {
        String[] lines = text.trim().split("\\r?\\n");
        int textWidth = 0;
        int textHeight = 9 * lines.length;
        for (String line : lines) {
            textWidth = Math.max(textWidth, fontRenderer.a(line));
            top -= 9;
        }
        left = Math.max(0, Math.min(screenWidth - 4, left - 4));
        top = Math.max(0, Math.min(screenHeight - 16, top + 9));
        GuiLiteLoaderPanel.a((int)(left - textWidth - 2), (int)top, (int)(left + 2), (int)(top + textHeight + 2), (int)backgroundColour);
        for (String line : lines) {
            fontRenderer.a(line, (float)(left - textWidth), (float)((top += 9) - 7), colour);
        }
    }

    static void glDrawTexturedRect(int x, int y, int width, int height, int u2, int v, int u22, int v2, float alpha) {
        float texMapScale = 0.00390625f;
        GuiLiteLoaderPanel.glDrawTexturedRect(x, y, width, height, (float)u2 * texMapScale, (float)v * texMapScale, (float)u22 * texMapScale, (float)v2 * texMapScale, alpha);
    }

    static void glDrawTexturedRect(int x, int y, int width, int height, float u2, float v, float u22, float v2, float alpha) {
        GL.glDisableLighting();
        GL.glEnableBlend();
        GL.glAlphaFunc(516, 0.0f);
        GL.glEnableTexture2D();
        GL.glColor4f(1.0f, 1.0f, 1.0f, alpha);
        bve tessellator = bve.a();
        buk buf = tessellator.c();
        buf.a(7, GL.VF_POSITION_TEX);
        buf.b((double)(x + 0), (double)(y + height), 0.0).a((double)u2, (double)v2).d();
        buf.b((double)(x + width), (double)(y + height), 0.0).a((double)u22, (double)v2).d();
        buf.b((double)(x + width), (double)(y + 0), 0.0).a((double)u22, (double)v).d();
        buf.b((double)(x + 0), (double)(y + 0), 0.0).a((double)u2, (double)v).d();
        tessellator.b();
        GL.glDisableBlend();
        GL.glAlphaFunc(516, 0.01f);
    }

    static void glDrawTexturedRect(int x, int y, Icon icon, float alpha) {
        GuiLiteLoaderPanel.glDrawTexturedRect(x, y, icon.getIconWidth(), icon.getIconHeight(), icon.getMinU(), icon.getMinV(), icon.getMaxU(), icon.getMaxV(), alpha);
    }
}

