/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.common.transformers;

import com.mumfrey.liteloader.core.runtime.Obf;
import com.mumfrey.liteloader.core.runtime.Packets;
import com.mumfrey.liteloader.transformers.event.Event;
import com.mumfrey.liteloader.transformers.event.EventInfo;
import java.util.HashSet;
import java.util.Set;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class PacketEvent
extends Event {
    private static Set<String> names = new HashSet<String>();
    private int packetIndex;

    PacketEvent(Packets packet) {
        super(PacketEvent.getPacketEventName(packet), true, 1000);
        this.packetIndex = packet.getIndex();
        this.verbose = false;
    }

    @Override
    public String getEventInfoClassName() {
        return "com/mumfrey/liteloader/common/transformers/PacketEventInfo";
    }

    @Override
    protected int invokeEventInfoConstructor(InsnList insns, boolean cancellable, boolean pushReturnValue, int marshallVar) {
        int ctorMAXS = 0;
        insns.add((AbstractInsnNode)new LdcInsnNode((Object)this.name));
        ++ctorMAXS;
        insns.add((AbstractInsnNode)(this.methodIsStatic ? new InsnNode(1) : new VarInsnNode(25, 0)));
        ++ctorMAXS;
        insns.add((AbstractInsnNode)new InsnNode(cancellable ? 4 : 3));
        insns.add((AbstractInsnNode)new IntInsnNode(16, this.packetIndex));
        insns.add((AbstractInsnNode)new MethodInsnNode(183, this.eventInfoClass, Obf.constructor.name, EventInfo.getConstructorDescriptor().replace(")", "I)"), false));
        return ++ctorMAXS;
    }

    private static String getPacketEventName(Packets packet) {
        String baseName = "on" + packet.getShortName();
        if (!names.contains(baseName)) {
            names.add(baseName);
            return baseName;
        }
        for (int ordinal = 1; ordinal < 33; ++ordinal) {
            String offsetName = String.format("%s#%d", baseName, ordinal);
            if (names.contains(offsetName)) continue;
            names.add(offsetName);
            return offsetName;
        }
        throw new IllegalArgumentException("Too many packet events with the same name: " + baseName);
    }
}

