/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core;

import com.mumfrey.liteloader.api.ContainerRegistry;
import com.mumfrey.liteloader.core.BadContainerInfo;
import com.mumfrey.liteloader.core.ModInfo;
import com.mumfrey.liteloader.core.NonMod;
import com.mumfrey.liteloader.interfaces.Loadable;
import com.mumfrey.liteloader.interfaces.LoadableMod;
import com.mumfrey.liteloader.interfaces.TweakContainer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class Containers
implements ContainerRegistry {
    private final Map<String, ModInfo<Loadable<?>>> disabledContainers = new HashMap();
    private final Map<String, LoadableMod<?>> enabledContainers = new HashMap();
    private final Set<ModInfo<Loadable<?>>> badContainers = new HashSet();
    private final List<TweakContainer<File>> tweakContainers = new ArrayList<TweakContainer<File>>();
    private final List<ModInfo<Loadable<?>>> injectedTweaks = new ArrayList();

    Containers() {
    }

    @Override
    public Collection<? extends ModInfo<Loadable<?>>> getDisabledContainers() {
        return this.disabledContainers.values();
    }

    @Override
    public Collection<? extends LoadableMod<?>> getEnabledContainers() {
        return this.enabledContainers.values();
    }

    @Override
    public Collection<? extends ModInfo<Loadable<?>>> getBadContainers() {
        return this.badContainers;
    }

    public List<TweakContainer<File>> getTweakContainers() {
        return this.tweakContainers;
    }

    public List<? extends ModInfo<Loadable<?>>> getInjectedTweaks() {
        return this.injectedTweaks;
    }

    @Override
    public boolean isDisabledContainer(LoadableMod<?> container) {
        return this.disabledContainers.containsValue(container);
    }

    @Override
    public LoadableMod<?> getEnabledContainer(String identifier) {
        LoadableMod<?> container = this.enabledContainers.get(identifier);
        return container != null ? container : LoadableMod.NONE;
    }

    @Override
    public void registerBadContainer(Loadable<?> container, String reason) {
        this.badContainers.add(new BadContainerInfo(container, reason));
    }

    @Override
    public void registerEnabledContainer(LoadableMod<?> container) {
        this.disabledContainers.remove(container.getIdentifier());
        this.enabledContainers.put(container.getIdentifier(), container);
    }

    @Override
    public void registerDisabledContainer(LoadableMod<?> container, ContainerRegistry.DisabledReason reason) {
        this.enabledContainers.remove(container.getIdentifier());
        this.disabledContainers.put(container.getIdentifier(), new NonMod((Loadable<?>)container, false));
    }

    @Override
    public void registerTweakContainer(TweakContainer<File> container) {
        this.tweakContainers.add(container);
    }

    @Override
    public void registerInjectedTweak(TweakContainer<File> container) {
        this.injectedTweaks.add(new NonMod((Loadable<?>)container, true));
    }
}

