/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core;

import com.google.common.collect.ImmutableSet;
import com.mumfrey.liteloader.LiteMod;
import com.mumfrey.liteloader.interfaces.Loadable;
import com.mumfrey.liteloader.interfaces.LoadableMod;
import com.mumfrey.liteloader.interfaces.MixinContainer;
import com.mumfrey.liteloader.interfaces.TweakContainer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public abstract class ModInfo<TContainer extends Loadable<?>> {
    protected static final Set<String> BUILT_IN_APIS = ImmutableSet.of((Object)"liteloader");
    protected final TContainer container;
    protected final boolean active;
    private final List<Throwable> startupErrors = new ArrayList<Throwable>();

    protected ModInfo(TContainer container, boolean active) {
        this.container = container;
        this.active = active;
    }

    public final boolean isActive() {
        return this.active;
    }

    public boolean isValid() {
        return true;
    }

    public boolean isToggleable() {
        return this.container.isToggleable();
    }

    public final boolean hasContainer() {
        return this.container != LoadableMod.NONE;
    }

    public final TContainer getContainer() {
        return this.container;
    }

    void registerStartupError(Throwable th) {
        this.startupErrors.add(th);
    }

    public List<Throwable> getStartupErrors() {
        return Collections.unmodifiableList(this.startupErrors);
    }

    public String getDisplayName() {
        return this.container.getDisplayName();
    }

    public String getVersion() {
        return this.container.getVersion();
    }

    public String getIdentifier() {
        return this.container.getIdentifier();
    }

    public String getURL() {
        return this.container instanceof LoadableMod ? ((LoadableMod)this.container).getMetaValue("url", "") : null;
    }

    public String getAuthor() {
        return this.container.getAuthor();
    }

    public String getDescription() {
        return this.container.getDescription(null);
    }

    public boolean hasTweakClass() {
        return this.container instanceof TweakContainer && ((TweakContainer)this.container).hasTweakClass();
    }

    public boolean hasClassTransformers() {
        return this.container instanceof TweakContainer && ((TweakContainer)this.container).hasClassTransformers();
    }

    public boolean hasEventTransformers() {
        return this.container instanceof TweakContainer && ((TweakContainer)this.container).hasEventTransformers();
    }

    public boolean hasMixins() {
        return this.container instanceof MixinContainer && ((MixinContainer)this.container).hasMixins();
    }

    public boolean usesAPI() {
        if (this.container instanceof LoadableMod) {
            for (String requiredAPI : ((LoadableMod)this.container).getRequiredAPIs()) {
                if (BUILT_IN_APIS.contains(requiredAPI)) continue;
                return true;
            }
        }
        return false;
    }

    public abstract LiteMod getMod();

    public abstract Class<? extends LiteMod> getModClass();

    public abstract String getModClassName();

    public abstract String getModClassSimpleName();
}

