/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core.api;

import com.mumfrey.liteloader.core.api.EnumeratorModuleFiles;
import com.mumfrey.liteloader.core.api.LiteLoaderCoreAPI;
import com.mumfrey.liteloader.interfaces.ModularEnumerator;
import com.mumfrey.liteloader.launch.LoaderEnvironment;
import com.mumfrey.liteloader.launch.LoaderProperties;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.io.File;

public class EnumeratorModuleFolder
extends EnumeratorModuleFiles {
    protected File directory;
    protected boolean readJarFiles;
    protected boolean loadTweaks;
    protected boolean forceInjection;
    protected final boolean loadTweakJars;

    public EnumeratorModuleFolder(LiteLoaderCoreAPI api, EnumeratorModuleFiles.ContainerEnvironment containers, File directory, boolean loadTweakJars) {
        super(api, containers);
        this.directory = directory;
        this.loadTweakJars = loadTweakJars;
    }

    @Override
    public void init(LoaderEnvironment environment, LoaderProperties properties) {
        this.loadTweaks = properties.loadTweaksEnabled();
        this.readJarFiles = properties.getAndStoreBooleanProperty("search.jarfiles", true);
        this.forceInjection = properties.getAndStoreBooleanProperty("forceInjection", false);
        this.api.writeDiscoverySettings();
    }

    @Override
    public void writeSettings(LoaderEnvironment environment, LoaderProperties properties) {
        properties.setBooleanProperty("search.jarfiles", this.readJarFiles);
        properties.setBooleanProperty("forceInjection", this.forceInjection);
    }

    @Override
    protected boolean forceInjection() {
        return this.forceInjection;
    }

    @Override
    protected boolean loadTweakJars() {
        return this.loadTweakJars;
    }

    @Override
    protected boolean loadTweaks() {
        return this.loadTweaks;
    }

    @Override
    protected boolean readJarFiles() {
        return this.readJarFiles;
    }

    @Override
    protected File[] getFiles() {
        return this.directory.listFiles(this.getFilenameFilter());
    }

    public String toString() {
        return this.directory.getAbsolutePath();
    }

    public File getDirectory() {
        return this.directory;
    }

    @Override
    public void enumerate(ModularEnumerator enumerator, String profile) {
        if (this.directory.exists() && this.directory.isDirectory()) {
            LiteLoaderLogger.info("Discovering valid mod files in folder %s", this.directory.getPath());
            this.findValidFiles(enumerator);
        }
    }

    @Override
    public void register(ModularEnumerator enumerator, String profile) {
        if (this.directory.exists() && this.directory.isDirectory()) {
            LiteLoaderLogger.info("Registering discovered mod files in folder %s", this.directory.getPath());
            this.sortAndRegisterFiles(enumerator);
        }
    }
}

