/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core.api;

import com.mumfrey.liteloader.core.api.EnumeratorModuleFiles;
import com.mumfrey.liteloader.core.api.LiteLoaderCoreAPI;
import com.mumfrey.liteloader.core.api.repository.Repository;
import com.mumfrey.liteloader.interfaces.ModularEnumerator;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.io.File;
import java.util.ArrayList;

public class EnumeratorModuleRepository
extends EnumeratorModuleFiles {
    private final File modList;
    private final Repository repo;
    private File[] files = new File[0];

    public EnumeratorModuleRepository(LiteLoaderCoreAPI api, EnumeratorModuleFiles.ContainerEnvironment containers, Repository repo, File modList) {
        super(api, containers);
        this.repo = repo;
        this.modList = modList;
    }

    public String toString() {
        return this.modList.getAbsolutePath();
    }

    public File getModList() {
        return this.modList;
    }

    @Override
    protected boolean readJarFiles() {
        return true;
    }

    @Override
    protected boolean loadTweakJars() {
        return true;
    }

    @Override
    protected boolean loadTweaks() {
        return true;
    }

    @Override
    protected boolean forceInjection() {
        return false;
    }

    @Override
    protected File[] getFiles() {
        return this.files;
    }

    @Override
    public void enumerate(ModularEnumerator enumerator, String profile) {
        if (this.modList.isFile()) {
            LiteLoaderLogger.info("Discovering mod files defined in repository %s", this.modList.getPath());
            this.resolve();
            this.findValidFiles(enumerator);
        }
    }

    @Override
    public void register(ModularEnumerator enumerator, String profile) {
        if (this.modList.isFile()) {
            LiteLoaderLogger.info("Discovering mod files defined in repository %s", this.modList.getPath());
            this.resolve();
            this.findValidFiles(enumerator);
            this.sortAndRegisterFiles(enumerator);
        }
    }

    private void resolve() {
        this.repo.resolve(this.modList);
        ArrayList<File> files = new ArrayList<File>();
        files.addAll(this.repo.getFiles());
        this.files = files.toArray(this.files);
    }
}

