/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core.api.repository;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Artefact {
    private static final Pattern PATTERN = Pattern.compile("^([^:]+):([^:]+):([^:@]+?)(:([^:@]+?))?(@(zip|jar|litemod))?$");
    private final String group;
    private final String name;
    private final String version;
    private final String classifier;
    private final String type;
    private File file;

    public Artefact(String specifier) {
        if (specifier == null) {
            throw new IllegalArgumentException("Invalid artefact specifier: null");
        }
        Matcher matcher = PATTERN.matcher(specifier);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid artefact specifier: " + specifier);
        }
        this.group = matcher.group(1);
        this.name = matcher.group(2);
        this.version = matcher.group(3);
        this.classifier = matcher.group(5);
        this.type = matcher.group(7);
    }

    public String getArtefactId() {
        return String.format("%s:%s", this.getGroup(), this.getName());
    }

    public String getPath() {
        return String.format("%s/%s/%s", this.getGroup().replace('.', '/'), this.getName(), this.getVersion());
    }

    public String getFileName() {
        return String.format("%s-%s%s.%s", this.getName(), this.getVersion(), this.getClassifier("-"), this.getType());
    }

    public String getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getClassifier() {
        return this.getClassifier("");
    }

    private String getClassifier(String prefix) {
        return this.classifier != null ? prefix + this.classifier : "";
    }

    public String getType() {
        return this.type != null ? this.type : "jar";
    }

    void resolve(File repositoryRoot) {
        this.file = new File(new File(repositoryRoot, this.getPath()), this.getFileName());
    }

    public boolean exists() {
        return this.file != null && this.file.isFile();
    }

    public File getFile() {
        return this.file;
    }

    public String toString() {
        String type = this.type != null && !"jar".equals(this.type) ? "@" + this.type : "";
        return String.format("%s:%s:%s%s%s", this.getGroup(), this.getName(), this.getVersion(), this.getClassifier(":"), type);
    }
}

