/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core.api.repository;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import com.mumfrey.liteloader.core.api.repository.Artefact;
import com.mumfrey.liteloader.core.api.repository.Repository;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class JsonResolver {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static final JsonResolver rootResolver = new JsonResolver().setRoot();
    @SerializedName(value="repositoryRoot")
    private String repositoryRoot;
    @SerializedName(value="modRef")
    private List<String> modRefs;
    @SerializedName(value="parentList")
    private String parentList;
    private transient boolean resolving = false;
    private transient File file;
    private transient File root;
    private transient JsonResolver parent;
    private final transient Map<String, Artefact> artefacts = new TreeMap<String, Artefact>();

    private JsonResolver() {
    }

    private JsonResolver setRoot() {
        this.parent = this;
        return this;
    }

    JsonResolver setFile(File file) {
        this.file = file;
        return this;
    }

    boolean isResolved() {
        return this.parent != null;
    }

    boolean isResolving() {
        return this.resolving;
    }

    public Map<String, Artefact> getArtefacts() {
        return Collections.unmodifiableMap(this.artefacts);
    }

    JsonResolver resolve(Repository repository) {
        if (!this.isResolved() && !this.isResolving()) {
            LiteLoaderLogger.info(LiteLoaderLogger.Verbosity.REDUCED, "Resolving mods in repository %s", this);
            this.doResolve(repository);
        }
        return this;
    }

    private void doResolve(Repository repository) {
        this.resolving = true;
        this.root = this.resolveRoot(repository);
        JsonResolver parent = this.resolveParent(repository);
        if (parent.isResolving()) {
            throw new IllegalStateException("Unexpected circular dependency in mod lists: " + this + " <-> " + parent);
        }
        this.artefacts.clear();
        this.artefacts.putAll(parent.artefacts);
        this.resolveArtefacts(repository);
        this.resolving = false;
        this.parent = parent;
    }

    private File resolveRoot(Repository repository) {
        if (this.repositoryRoot == null) {
            if (this.file != null) {
                return this.file.getParentFile();
            }
            return repository.getDefaultRepositoryRoot();
        }
        if (Repository.isAbsolutePath(this.repositoryRoot)) {
            return new File(this.repositoryRoot);
        }
        return new File(repository.getRoot(), this.repositoryRoot);
    }

    private JsonResolver resolveParent(Repository repository) {
        if (this.parentList == null) {
            return rootResolver;
        }
        if (Repository.isAbsolutePath(this.parentList)) {
            File path = new File(this.parentList);
            return repository.getResolver(path).resolve(repository);
        }
        File path = new File(repository.getRoot(), this.parentList);
        return repository.getResolver(path).resolve(repository);
    }

    private void resolveArtefacts(Repository repository) {
        if (this.modRefs == null) {
            return;
        }
        for (String ref : this.modRefs) {
            if (Strings.isNullOrEmpty((String)ref)) continue;
            try {
                Artefact artefact = new Artefact(ref);
                artefact.resolve(this.root);
                LiteLoaderLogger.info(LiteLoaderLogger.Verbosity.VERBOSE, "Resolved artefact '%s' at %s", artefact.getArtefactId(), artefact.getFile());
                String artefactId = artefact.getArtefactId();
                Artefact existing = this.artefacts.get(artefactId);
                if (existing != null) {
                    LiteLoaderLogger.info(LiteLoaderLogger.Verbosity.VERBOSE, "Evicting artefact '%s' -> '%s'", existing, artefact.getVersion());
                }
                this.artefacts.put(artefactId, artefact);
            }
            catch (IllegalArgumentException ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static JsonResolver createFrom(File file) {
        if (!file.isFile()) return new JsonResolver().setFile(file);
        try (FileReader reader = new FileReader(file);){
            JsonResolver jsonResolver = ((JsonResolver)gson.fromJson((Reader)reader, JsonResolver.class)).setFile(file);
            return jsonResolver;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return new JsonResolver().setFile(file);
    }

    public String toString() {
        return this.file.getPath();
    }
}

