/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core.runtime;

import com.google.common.base.Objects;

public final class SrgMethod {
    private final String name;
    private final String desc;

    public SrgMethod(String name, String desc) {
        this.name = name;
        this.desc = desc;
    }

    public SrgMethod(String owner, String simpleName, String desc) {
        this.name = SrgMethod.createName(owner, simpleName);
        this.desc = desc;
    }

    public String getName() {
        return this.name;
    }

    public String getSimpleName() {
        if (this.name == null) {
            return null;
        }
        int pos = this.name.lastIndexOf(47);
        return pos > -1 ? this.name.substring(pos + 1) : this.name;
    }

    public String getOwner() {
        if (this.name == null) {
            return null;
        }
        int pos = this.name.lastIndexOf(47);
        return pos > -1 ? this.name.substring(0, pos) : null;
    }

    public String getDesc() {
        return this.desc;
    }

    public SrgMethod move(String newOwner) {
        return new SrgMethod(newOwner, this.getSimpleName(), this.desc);
    }

    public SrgMethod copy() {
        return new SrgMethod(this.name, this.desc);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.desc});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SrgMethod) {
            return Objects.equal((Object)this.name, (Object)((SrgMethod)obj).name) && Objects.equal((Object)this.desc, (Object)((SrgMethod)obj).desc);
        }
        return false;
    }

    public String toString() {
        return String.format("%s %s", this.name, this.desc);
    }

    private static String createName(String owner, String simpleName) {
        return (owner != null ? owner + "/" : "") + simpleName;
    }
}

