/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.launch;

import com.mumfrey.liteloader.launch.InjectionStrategy;
import com.mumfrey.liteloader.launch.JarDeletionHandler;
import com.mumfrey.liteloader.launch.LiteLoaderTweaker;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.jar.JarFile;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;

public abstract class ClassPathUtilities {
    private static Class<?> clURLClassPath;
    private static Field ucp;
    private static Field classPathURLs;
    private static Field classPathPath;
    private static Field classPathLoaderMap;
    private static Field classPathLoaderList;
    private static boolean canInject;
    private static boolean canTerminate;

    public static void injectIntoClassPath(URLClassLoader classLoader, URL url, InjectionStrategy strategy) {
        if (strategy == null || strategy.getPosition() == null) {
            ClassPathUtilities.addURL(classLoader, url);
            return;
        }
        if (strategy.getPosition() == InjectionStrategy.InjectionPosition.Top) {
            ClassPathUtilities.injectIntoClassPath(classLoader, url);
        } else if (strategy.getPosition() == InjectionStrategy.InjectionPosition.Base) {
            ClassPathUtilities.injectIntoClassPath(classLoader, url, LiteLoaderTweaker.getJarUrl());
        } else if (strategy.getPosition() == InjectionStrategy.InjectionPosition.Above) {
            String[] params = strategy.getParams();
            if (params.length > 0) {
                ClassPathUtilities.injectIntoClassPath(classLoader, url, params[0]);
            }
        } else {
            ClassPathUtilities.addURL(classLoader, url);
        }
    }

    public static void injectIntoClassPath(URLClassLoader classLoader, URL url) {
        ClassPathUtilities.injectIntoClassPath(classLoader, url, (URL)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void injectIntoClassPath(URLClassLoader classLoader, URL url, URL above) {
        if (canInject) {
            LiteLoaderLogger.info("ClassPathUtilities: attempting to inject %s into %s", url, classLoader.getClass().getSimpleName());
            try {
                Object classPath = ucp.get(classLoader);
                Stack urls = (Stack)classPathURLs.get(classPath);
                ArrayList path = (ArrayList)classPathPath.get(classPath);
                Stack stack = urls;
                synchronized (stack) {
                    if (!path.contains(url)) {
                        urls.add(url);
                        if (above == null) {
                            path.add(0, url);
                        } else {
                            for (int pos = path.size() - 1; pos > 0; --pos) {
                                if (!above.equals(path.get(pos))) continue;
                                path.add(pos, url);
                            }
                        }
                    }
                }
            }
            catch (Exception ex) {
                LiteLoaderLogger.warning("ClassPathUtilities: failed to inject %s", url);
            }
        }
        ClassPathUtilities.addURL(classLoader, url);
    }

    public static void injectIntoClassPath(URLClassLoader classLoader, URL url, String above) {
        if ((above = above.trim().toLowerCase()).length() < 1) {
            return;
        }
        for (URL classPathUrl : classLoader.getURLs()) {
            if (!classPathUrl.toString().toLowerCase().contains(above)) continue;
            ClassPathUtilities.injectIntoClassPath(classLoader, url, classPathUrl);
            return;
        }
    }

    public static void addURL(URLClassLoader classLoader, URL url) {
        if (classLoader instanceof LaunchClassLoader) {
            ((LaunchClassLoader)classLoader).addURL(url);
        } else {
            try {
                Method mAddUrl = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                mAddUrl.setAccessible(true);
                mAddUrl.invoke((Object)classLoader, url);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean isJarOnClassPath(File jarFile) {
        URLClassLoader classLoader = (URLClassLoader)Launch.class.getClassLoader();
        return ClassPathUtilities.isJarOnClassPath(jarFile, classLoader);
    }

    public static boolean isJarOnClassPath(File jarFile, URLClassLoader classLoader) {
        try {
            URL[] classPath;
            String jarURL = jarFile.toURI().toURL().toString();
            for (URL classPathEntry : classPath = classLoader.getURLs()) {
                if (!classPathEntry.toString().equals(jarURL)) continue;
                return true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public static File getPathToResource(Class<?> contextClass, String resource) {
        URL res = contextClass.getResource(resource);
        if (res == null) {
            return null;
        }
        boolean returnParent = true;
        String jarPath = res.toString();
        if (jarPath.startsWith("jar:") && jarPath.indexOf(33) > -1) {
            jarPath = jarPath.substring(4, jarPath.indexOf(33));
            returnParent = false;
        }
        if (jarPath.startsWith("file:")) {
            try {
                File targetFile = new File(new URI(jarPath));
                return returnParent ? targetFile.getParentFile() : targetFile;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean deleteClassPathJarContaining(Class<?> contextClass, String resource) {
        File jarFile = ClassPathUtilities.getPathToResource(contextClass, resource);
        if (jarFile != null && jarFile.exists() && jarFile.isFile() && jarFile.getName().endsWith(".jar")) {
            return ClassPathUtilities.deleteClassPathJar(jarFile.getName());
        }
        return false;
    }

    public static boolean deleteClassPathJar(String jarFileName) {
        try {
            JarFile jar = ClassPathUtilities.getJarFromClassLoader((URLClassLoader)Launch.classLoader, jarFileName, false);
            JarFile parentJar = ClassPathUtilities.getJarFromClassLoader((URLClassLoader)Launch.class.getClassLoader(), jarFileName, false);
            if (jar != null && parentJar != null && jar.getName().equals(parentJar.getName())) {
                JarDeletionHandler jarDeletionHandler = new JarDeletionHandler();
                JarFile jarInClassLoader = ClassPathUtilities.getJarFromClassLoader((URLClassLoader)Launch.classLoader, jarFileName, true);
                JarFile jarInParentClassLoader = ClassPathUtilities.getJarFromClassLoader((URLClassLoader)Launch.class.getClassLoader(), jarFileName, true);
                File jarFileInClassLoader = new File(jarInClassLoader.getName());
                File jarFileInParentClassLoader = new File(jarInParentClassLoader.getName());
                jarDeletionHandler.setPaths(jarInClassLoader, jarInParentClassLoader, jarFileInClassLoader, jarFileInParentClassLoader);
                try {
                    Boolean deleted = AccessController.doPrivileged(jarDeletionHandler);
                    canTerminate |= deleted.booleanValue();
                    return deleted;
                }
                catch (PrivilegedActionException ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public static void terminateRuntime(int status) {
        if (!canTerminate) {
            throw new IllegalStateException();
        }
        System.exit(status);
    }

    private static JarFile getJarFromClassLoader(URLClassLoader classLoader, String fileName, boolean removeFromClassPath) throws MalformedURLException {
        JarFile jar = null;
        try {
            Object classPath = ucp.get(classLoader);
            Map loaderMap = (Map)classPathLoaderMap.get(classPath);
            Iterator iter = loaderMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry loaderEntry = iter.next();
                String url = (String)loaderEntry.getKey();
                if (!url.endsWith(fileName)) continue;
                Object loader = loaderEntry.getValue();
                Field jarField = loader.getClass().getDeclaredField("jar");
                jarField.setAccessible(true);
                jar = (JarFile)jarField.get(loader);
                if (!removeFromClassPath) continue;
                jarField.set(loader, null);
                Stack urls = (Stack)classPathURLs.get(classPath);
                ArrayList path = (ArrayList)classPathPath.get(classPath);
                ArrayList loaders = (ArrayList)classPathLoaderList.get(classPath);
                loaders.remove(loader);
                iter.remove();
                URL jarURL = new URL(url);
                urls.remove(jarURL);
                path.remove(jarURL);
            }
        }
        catch (IllegalArgumentException classPath) {
        }
        catch (SecurityException classPath) {
        }
        catch (IllegalAccessException classPath) {
        }
        catch (NoSuchFieldException ex) {
            ex.printStackTrace();
        }
        return jar;
    }

    static {
        try {
            clURLClassPath = Class.forName("sun.misc.URLClassPath");
            ucp = URLClassLoader.class.getDeclaredField("ucp");
            ucp.setAccessible(true);
            classPathURLs = clURLClassPath.getDeclaredField("urls");
            classPathURLs.setAccessible(true);
            classPathPath = clURLClassPath.getDeclaredField("path");
            classPathPath.setAccessible(true);
            classPathLoaderMap = clURLClassPath.getDeclaredField("lmap");
            classPathLoaderMap.setAccessible(true);
            classPathLoaderList = clURLClassPath.getDeclaredField("loaders");
            classPathLoaderList.setAccessible(true);
            canInject = true;
        }
        catch (Throwable th) {
            LiteLoaderLogger.severe(th, "ClassPathUtilities: Error initialising ClassPathUtilities, special class path injection disabled", new Object[0]);
            th.printStackTrace();
        }
    }
}

