/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.launch;

import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraft.launchwrapper.LogWrapper;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;

public class ClassTransformerManager {
    private boolean gameStarted;
    private Set<String> downstreamTransformers = new LinkedHashSet<String>();
    private final List<String> requiredTransformers;
    private final Set<String> injectedTransformers = new LinkedHashSet<String>();
    private final Map<String, List<Throwable>> transformerStartupErrors = new HashMap<String, List<Throwable>>();
    private Logger attachedLog;
    private String pendingTransformer;

    public ClassTransformerManager(List<String> requiredTransformers) {
        this.requiredTransformers = requiredTransformers;
        this.appendObserver();
    }

    private void appendObserver() {
        try {
            Field fLogger = LogWrapper.class.getDeclaredField("myLog");
            fLogger.setAccessible(true);
            this.attachedLog = (Logger)fLogger.get(LogWrapper.log);
            if (this.attachedLog instanceof org.apache.logging.log4j.core.Logger) {
                ((org.apache.logging.log4j.core.Logger)this.attachedLog).addAppender((Appender)new ThrowableObserver());
            }
        }
        catch (Exception ex) {
            LiteLoaderLogger.warning("Failed to append ThrowableObserver to LogWrapper, transformer startup exceptions may not be logged", new Object[0]);
        }
    }

    public boolean injectTransformer(String transformerClass) {
        if (!this.gameStarted) {
            this.downstreamTransformers.add(transformerClass);
            return true;
        }
        return false;
    }

    public boolean injectTransformers(Collection<String> transformerClasses) {
        if (!this.gameStarted) {
            this.downstreamTransformers.addAll(transformerClasses);
            return true;
        }
        return false;
    }

    public boolean injectTransformers(String[] transformerClasses) {
        if (!this.gameStarted) {
            this.downstreamTransformers.addAll(Arrays.asList(transformerClasses));
            return true;
        }
        return false;
    }

    void injectUpstreamTransformers(LaunchClassLoader classLoader) {
        for (String requiredTransformerClassName : this.requiredTransformers) {
            LiteLoaderLogger.info(LiteLoaderLogger.Verbosity.REDUCED, "Injecting required class transformer '%s'", requiredTransformerClassName);
            this.injectTransformer(classLoader, requiredTransformerClassName);
        }
    }

    void injectDownstreamTransformers(LaunchClassLoader classLoader) {
        this.gameStarted = true;
        if (this.downstreamTransformers.size() > 0) {
            LiteLoaderLogger.info("Injecting downstream transformers", new Object[0]);
        }
        for (String transformerClassName : this.downstreamTransformers) {
            LiteLoaderLogger.info(LiteLoaderLogger.Verbosity.REDUCED, "Injecting additional class transformer class '%s'", transformerClassName);
            this.injectTransformer(classLoader, transformerClassName);
        }
        this.downstreamTransformers.clear();
    }

    private synchronized void injectTransformer(LaunchClassLoader classLoader, String transformerClassName) {
        try {
            this.pendingTransformer = transformerClassName;
            classLoader.registerTransformer(transformerClassName);
            this.pendingTransformer = null;
            if (this.findTransformer(classLoader, transformerClassName) != null) {
                this.injectedTransformers.add(transformerClassName);
            }
        }
        catch (Throwable th) {
            LiteLoaderLogger.severe(th, "Error injecting class transformer class %s", transformerClassName);
        }
    }

    public void observeThrowable(Throwable th) {
        if (th != null && this.pendingTransformer != null) {
            List<Throwable> transformerErrors = this.transformerStartupErrors.get(this.pendingTransformer);
            if (transformerErrors == null) {
                transformerErrors = new ArrayList<Throwable>();
                this.transformerStartupErrors.put(this.pendingTransformer, transformerErrors);
            }
            transformerErrors.add(th);
        }
    }

    private IClassTransformer findTransformer(LaunchClassLoader classLoader, String transformerClassName) {
        for (IClassTransformer transformer : classLoader.getTransformers()) {
            if (!transformer.getClass().getName().equals(transformerClassName)) continue;
            return transformer;
        }
        return null;
    }

    public Set<String> getInjectedTransformers() {
        return Collections.unmodifiableSet(this.injectedTransformers);
    }

    public List<Throwable> getTransformerStartupErrors(String transformerClassName) {
        List<Throwable> errorList = this.transformerStartupErrors.get(transformerClassName);
        return errorList != null ? Collections.unmodifiableList(errorList) : null;
    }

    class ThrowableObserver
    extends AbstractAppender {
        public ThrowableObserver() {
            super("Throwable Observer", null, null);
            this.start();
        }

        public void append(LogEvent event) {
            ClassTransformerManager.this.observeThrowable(event.getThrown());
        }
    }
}

