/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.transformers;

import com.mumfrey.liteloader.core.runtime.Obf;
import com.mumfrey.liteloader.transformers.Obfuscated;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.tree.analysis.SimpleVerifier;

public abstract class ByteCodeUtilities {
    private static Map<String, List<LocalVariableNode>> calculatedLocalVariables = new HashMap<String, List<LocalVariableNode>>();

    private ByteCodeUtilities() {
    }

    public static void replaceConstructors(ClassNode classNode, Obf target, Obf replacement) {
        for (MethodNode method : classNode.methods) {
            ByteCodeUtilities.replaceConstructors(method, target, replacement);
        }
    }

    public static void replaceConstructors(MethodNode method, Obf target, Obf replacement) {
        for (AbstractInsnNode insn : method.instructions) {
            if (insn.getOpcode() == 187) {
                TypeInsnNode typeInsn = (TypeInsnNode)insn;
                if (!target.obf.equals(typeInsn.desc) && !target.ref.equals(typeInsn.desc)) continue;
                typeInsn.desc = replacement.ref;
                continue;
            }
            if (!(insn instanceof MethodInsnNode) || insn.getOpcode() != 183) continue;
            MethodInsnNode methodInsn = (MethodInsnNode)insn;
            if (!target.obf.equals(methodInsn.owner) && !target.ref.equals(methodInsn.owner) || !"<init>".equals(methodInsn.name)) continue;
            methodInsn.owner = replacement.ref;
        }
    }

    public static void loadArgs(Type[] args, InsnList insns, int pos) {
        ByteCodeUtilities.loadArgs(args, insns, pos, -1);
    }

    public static void loadArgs(Type[] args, InsnList insns, int start, int end) {
        int pos = start;
        for (Type type : args) {
            insns.add((AbstractInsnNode)new VarInsnNode(type.getOpcode(21), pos));
            if (end < start || (pos += type.getSize()) < end) continue;
            return;
        }
    }

    public static void loadLocals(Type[] locals, InsnList insns, int pos) {
        while (pos < locals.length) {
            if (locals[pos] != null) {
                insns.add((AbstractInsnNode)new VarInsnNode(locals[pos].getOpcode(21), pos));
            }
            ++pos;
        }
    }

    public static int getFirstNonArgLocalIndex(MethodNode method) {
        return ByteCodeUtilities.getFirstNonArgLocalIndex(Type.getArgumentTypes((String)method.desc), (method.access & 8) == 0);
    }

    public static int getFirstNonArgLocalIndex(Type[] args, boolean includeThis) {
        return ByteCodeUtilities.getArgsSize(args) + (includeThis ? 1 : 0);
    }

    public static int getArgsSize(Type[] args) {
        int size = 0;
        for (Type type : args) {
            size += type.getSize();
        }
        return size;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LocalVariableNode[] getLocalsAt(ClassNode classNode, MethodNode method, AbstractInsnNode node) {
        LocalVariableNode[] frame = new LocalVariableNode[method.maxLocals];
        if ((method.access & 8) == 0) {
            frame[0] = new LocalVariableNode("this", classNode.name, null, null, null, 0);
        }
        for (AbstractInsnNode insn : method.instructions) {
            if (insn instanceof FrameNode) {
                FrameNode frameNode = (FrameNode)insn;
                int localPos = 0;
                int framePos = 0;
                while (framePos < frame.length) {
                    Object localType;
                    Object v0 = localType = localPos < frameNode.local.size() ? frameNode.local.get(localPos) : null;
                    if (localType instanceof String) {
                        frame[framePos] = ByteCodeUtilities.getLocalVariableAt(classNode, method, node, framePos);
                    } else if (localType instanceof Integer) {
                        boolean is64bitValue;
                        boolean isMarkerType = localType == Opcodes.UNINITIALIZED_THIS || localType == Opcodes.TOP || localType == Opcodes.NULL;
                        boolean is32bitValue = localType == Opcodes.INTEGER || localType == Opcodes.FLOAT;
                        boolean bl2 = is64bitValue = localType == Opcodes.DOUBLE || localType == Opcodes.LONG;
                        if (isMarkerType) {
                            frame[framePos] = null;
                        } else {
                            if (!is32bitValue && !is64bitValue) throw new RuntimeException("Unrecognised locals opcode " + localType + " in locals array at position " + localPos + " in " + classNode.name + "." + method.name + method.desc);
                            frame[framePos] = ByteCodeUtilities.getLocalVariableAt(classNode, method, node, framePos);
                            if (is64bitValue) {
                                frame[++framePos] = null;
                            }
                        }
                    } else {
                        if (localType != null) throw new RuntimeException("Invalid value " + localType + " in locals array at position " + localPos + " in " + classNode.name + "." + method.name + method.desc);
                        frame[framePos] = null;
                    }
                    ++framePos;
                    ++localPos;
                }
                continue;
            }
            if (insn instanceof VarInsnNode) {
                VarInsnNode varNode = (VarInsnNode)insn;
                frame[varNode.var] = ByteCodeUtilities.getLocalVariableAt(classNode, method, node, varNode.var);
                continue;
            }
            if (insn != node) continue;
            return frame;
        }
        return frame;
    }

    public static LocalVariableNode getLocalVariableAt(ClassNode classNode, MethodNode method, AbstractInsnNode node, int var) {
        LocalVariableNode localVariableNode = null;
        int pos = method.instructions.indexOf(node);
        List<LocalVariableNode> localVariables = ByteCodeUtilities.getLocalVariableTable(classNode, method);
        for (LocalVariableNode local : localVariables) {
            if (local.index != var) continue;
            int start = method.instructions.indexOf((AbstractInsnNode)local.start);
            int end = method.instructions.indexOf((AbstractInsnNode)local.end);
            if (localVariableNode != null && (start >= pos || end <= pos)) continue;
            localVariableNode = local;
        }
        return localVariableNode;
    }

    public static List<LocalVariableNode> getLocalVariableTable(ClassNode classNode, MethodNode method) {
        if (method.localVariables.isEmpty()) {
            String signature = String.format("%s.%s%s", classNode.name, method.name, method.desc);
            List<LocalVariableNode> localVars = calculatedLocalVariables.get(signature);
            if (localVars != null) {
                return localVars;
            }
            localVars = ByteCodeUtilities.generateLocalVariableTable(classNode, method);
            calculatedLocalVariables.put(signature, localVars);
            return localVars;
        }
        return method.localVariables;
    }

    public static List<LocalVariableNode> generateLocalVariableTable(ClassNode classNode, MethodNode method) {
        ArrayList<Type> interfaces = null;
        if (classNode.interfaces != null) {
            interfaces = new ArrayList<Type>();
            for (String iface : classNode.interfaces) {
                interfaces.add(Type.getObjectType((String)iface));
            }
        }
        Type objectType = null;
        if (classNode.superName != null) {
            objectType = Type.getObjectType((String)classNode.superName);
        }
        Analyzer analyzer = new Analyzer((Interpreter)new SimpleVerifier(Type.getObjectType((String)classNode.name), objectType, interfaces, false));
        try {
            analyzer.analyze(classNode.name, method);
        }
        catch (AnalyzerException ex) {
            ex.printStackTrace();
        }
        Frame[] frames = analyzer.getFrames();
        int methodSize = method.instructions.size();
        ArrayList<LocalVariableNode> localVariables = new ArrayList<LocalVariableNode>();
        LocalVariableNode[] localNodes = new LocalVariableNode[method.maxLocals];
        BasicValue[] locals = new BasicValue[method.maxLocals];
        LabelNode[] labels = new LabelNode[methodSize];
        for (int i = 0; i < methodSize; ++i) {
            Frame f = frames[i];
            if (f == null) continue;
            LabelNode label = null;
            for (int j = 0; j < f.getLocals(); ++j) {
                BasicValue local = (BasicValue)f.getLocal(j);
                if (local == null && locals[j] == null || local != null && local.equals((Object)locals[j])) continue;
                if (label == null) {
                    labels[i] = label = new LabelNode();
                }
                if (local == null && locals[j] != null) {
                    localVariables.add(localNodes[j]);
                    localNodes[j].end = label;
                    localNodes[j] = null;
                } else if (local != null) {
                    if (locals[j] != null) {
                        localVariables.add(localNodes[j]);
                        localNodes[j].end = label;
                        localNodes[j] = null;
                    }
                    String desc = local.getType() != null ? local.getType().getDescriptor() : null;
                    localNodes[j] = new LocalVariableNode("var" + j, desc, null, label, null, j);
                }
                locals[j] = local;
            }
        }
        LabelNode label = null;
        for (int k = 0; k < localNodes.length; ++k) {
            if (localNodes[k] == null) continue;
            if (label == null) {
                label = new LabelNode();
                method.instructions.add((AbstractInsnNode)label);
            }
            localNodes[k].end = label;
            localVariables.add(localNodes[k]);
        }
        for (int n = methodSize - 1; n >= 0; --n) {
            if (labels[n] == null) continue;
            method.instructions.insert(method.instructions.get(n), (AbstractInsnNode)labels[n]);
        }
        return localVariables;
    }

    public static String getTypeName(Type type) {
        switch (type.getSort()) {
            case 1: {
                return "boolean";
            }
            case 2: {
                return "char";
            }
            case 3: {
                return "byte";
            }
            case 4: {
                return "short";
            }
            case 5: {
                return "int";
            }
            case 6: {
                return "float";
            }
            case 7: {
                return "long";
            }
            case 8: {
                return "double";
            }
            case 9: {
                return ByteCodeUtilities.getTypeName(type.getElementType()) + "[]";
            }
            case 10: {
                String typeName = type.getClassName();
                typeName = typeName.substring(typeName.lastIndexOf(46) + 1);
                return typeName;
            }
        }
        return "Object";
    }

    public static MethodNode findTargetMethod(ClassNode targetClass, MethodNode searchFor) {
        for (MethodNode target : targetClass.methods) {
            if (!target.name.equals(searchFor.name) || !target.desc.equals(searchFor.desc)) continue;
            return target;
        }
        AnnotationNode obfuscatedAnnotation = ByteCodeUtilities.getVisibleAnnotation(searchFor, Obfuscated.class);
        if (obfuscatedAnnotation != null) {
            for (String obfuscatedName : (List)ByteCodeUtilities.getAnnotationValue(obfuscatedAnnotation)) {
                for (MethodNode target : targetClass.methods) {
                    if (!target.name.equals(obfuscatedName) || !target.desc.equals(searchFor.desc)) continue;
                    return target;
                }
            }
        }
        return null;
    }

    public static FieldNode findTargetField(ClassNode targetClass, FieldNode searchFor) {
        for (FieldNode target : targetClass.fields) {
            if (!target.name.equals(searchFor.name)) continue;
            return target;
        }
        AnnotationNode obfuscatedAnnotation = ByteCodeUtilities.getVisibleAnnotation(searchFor, Obfuscated.class);
        if (obfuscatedAnnotation != null) {
            for (String obfuscatedName : (List)ByteCodeUtilities.getAnnotationValue(obfuscatedAnnotation)) {
                for (FieldNode target : targetClass.fields) {
                    if (!target.name.equals(obfuscatedName)) continue;
                    return target;
                }
            }
        }
        return null;
    }

    public static MethodNode findMethod(ClassNode classNode, Obf searchFor, String desc) {
        int ordinal = 0;
        for (MethodNode method : classNode.methods) {
            if (!searchFor.matches(method.name, ordinal++) || !method.desc.equals(desc)) continue;
            return method;
        }
        return null;
    }

    public static FieldNode findField(ClassNode classNode, Obf searchFor) {
        int ordinal = 0;
        for (FieldNode field : classNode.fields) {
            if (!searchFor.matches(field.name, ordinal++)) continue;
            return field;
        }
        return null;
    }

    public static ClassNode loadClass(String className) throws IOException {
        return ByteCodeUtilities.loadClass(className, true, null);
    }

    public static ClassNode loadClass(String className, boolean runTransformers) throws IOException {
        return ByteCodeUtilities.loadClass(className, runTransformers, null);
    }

    public static ClassNode loadClass(String className, IClassTransformer source) throws IOException {
        return ByteCodeUtilities.loadClass(className, source != null, source);
    }

    public static ClassNode loadClass(String className, boolean runTransformers, IClassTransformer source) throws IOException {
        byte[] bytes = Launch.classLoader.getClassBytes(className);
        if (runTransformers) {
            bytes = ByteCodeUtilities.applyTransformers(className, bytes, source);
        }
        return ByteCodeUtilities.readClass(bytes);
    }

    public static ClassNode readClass(byte[] basicClass) {
        ClassReader classReader = new ClassReader(basicClass);
        ClassNode classNode = new ClassNode();
        classReader.accept((ClassVisitor)classNode, 8);
        return classNode;
    }

    public static byte[] applyTransformers(String className, byte[] basicClass) {
        return ByteCodeUtilities.applyTransformers(className, basicClass, null);
    }

    public static byte[] applyTransformers(String className, byte[] basicClass, IClassTransformer source) {
        List transformers = Launch.classLoader.getTransformers();
        for (IClassTransformer transformer : transformers) {
            if (transformer == source) continue;
            basicClass = transformer.transform(className, className, basicClass);
        }
        return basicClass;
    }

    public static AnnotationNode getVisibleAnnotation(FieldNode field, Class<? extends Annotation> annotationClass) {
        return ByteCodeUtilities.getAnnotation(field.visibleAnnotations, Type.getDescriptor(annotationClass));
    }

    public static AnnotationNode getInvisibleAnnotation(FieldNode field, Class<? extends Annotation> annotationClass) {
        return ByteCodeUtilities.getAnnotation(field.invisibleAnnotations, Type.getDescriptor(annotationClass));
    }

    public static AnnotationNode getVisibleAnnotation(MethodNode method, Class<? extends Annotation> annotationClass) {
        return ByteCodeUtilities.getAnnotation(method.visibleAnnotations, Type.getDescriptor(annotationClass));
    }

    public static AnnotationNode getInvisibleAnnotation(MethodNode method, Class<? extends Annotation> annotationClass) {
        return ByteCodeUtilities.getAnnotation(method.invisibleAnnotations, Type.getDescriptor(annotationClass));
    }

    public static AnnotationNode getVisibleAnnotation(ClassNode classNode, Class<? extends Annotation> annotationClass) {
        return ByteCodeUtilities.getAnnotation(classNode.visibleAnnotations, Type.getDescriptor(annotationClass));
    }

    public static AnnotationNode getInvisibleAnnotation(ClassNode classNode, Class<? extends Annotation> annotationClass) {
        return ByteCodeUtilities.getAnnotation(classNode.invisibleAnnotations, Type.getDescriptor(annotationClass));
    }

    public static AnnotationNode getAnnotation(List<AnnotationNode> annotations, String annotationType) {
        if (annotations != null) {
            for (AnnotationNode annotation : annotations) {
                if (!annotationType.equals(annotation.desc)) continue;
                return annotation;
            }
        }
        return null;
    }

    public static <T> T getAnnotationValue(AnnotationNode annotation) {
        return ByteCodeUtilities.getAnnotationValue(annotation, "value");
    }

    public static <T> T getAnnotationValue(AnnotationNode annotation, String key) {
        if (annotation == null || annotation.values == null) {
            return null;
        }
        boolean getNextValue = false;
        for (Object value : annotation.values) {
            if (getNextValue) {
                return (T)value;
            }
            if (!value.equals(key)) continue;
            getNextValue = true;
        }
        return null;
    }

    public static String generateDescriptor(Type returnType, Object ... args) {
        return ByteCodeUtilities.generateDescriptor(0, (Object)returnType, args);
    }

    public static String generateDescriptor(Obf returnType, Object ... args) {
        return ByteCodeUtilities.generateDescriptor(0, (Object)returnType, args);
    }

    public static String generateDescriptor(String returnType, Object ... args) {
        return ByteCodeUtilities.generateDescriptor(0, (Object)returnType, args);
    }

    public static String generateDescriptor(int obfType, Object returnType, Object ... args) {
        StringBuilder sb = new StringBuilder().append('(');
        for (Object arg : args) {
            sb.append(ByteCodeUtilities.toDescriptor(obfType, arg));
        }
        return sb.append(')').append(returnType != null ? ByteCodeUtilities.toDescriptor(obfType, returnType) : "V").toString();
    }

    private static String toDescriptor(int obfType, Object arg) {
        if (arg instanceof Obf) {
            return ((Obf)arg).getDescriptor(obfType);
        }
        if (arg instanceof String) {
            return (String)arg;
        }
        if (arg instanceof Type) {
            return arg.toString();
        }
        if (arg instanceof Class) {
            return Type.getDescriptor((Class)((Class)arg)).toString();
        }
        return arg == null ? "" : arg.toString();
    }
}

