/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.transformers.event.json;

import com.google.gson.annotations.SerializedName;
import com.mumfrey.liteloader.transformers.event.InjectionPoint;
import com.mumfrey.liteloader.transformers.event.MethodInfo;
import com.mumfrey.liteloader.transformers.event.inject.BeforeInvoke;
import com.mumfrey.liteloader.transformers.event.inject.BeforeReturn;
import com.mumfrey.liteloader.transformers.event.inject.BeforeStringInvoke;
import com.mumfrey.liteloader.transformers.event.inject.MethodHead;
import com.mumfrey.liteloader.transformers.event.json.InvalidEventJsonException;
import com.mumfrey.liteloader.transformers.event.json.JsonInjectionShiftType;
import com.mumfrey.liteloader.transformers.event.json.JsonInjectionType;
import com.mumfrey.liteloader.transformers.event.json.JsonMethods;
import java.io.Serializable;
import java.lang.reflect.Constructor;

public class JsonInjection
implements Serializable {
    private static final long serialVersionUID = 1L;
    @SerializedName(value="method")
    private String methodName;
    @SerializedName(value="type")
    private JsonInjectionType type;
    @SerializedName(value="shift")
    private JsonInjectionShiftType shift;
    @SerializedName(value="target")
    private String target;
    @SerializedName(value="ordinal")
    private int ordinal = -1;
    @SerializedName(value="class")
    private String className;
    @SerializedName(value="args")
    private Object[] args;
    private transient MethodInfo method;
    private transient InjectionPoint injectionPoint;

    public MethodInfo getMethod() {
        return this.method;
    }

    public InjectionPoint getInjectionPoint() {
        return this.injectionPoint;
    }

    public void parse(JsonMethods methods) {
        this.method = this.parseMethod(methods);
        this.injectionPoint = this.parseInjectionPoint(methods);
    }

    private MethodInfo parseMethod(JsonMethods methods) {
        try {
            return methods.get(this.methodName);
        }
        catch (NullPointerException ex) {
            throw new InvalidEventJsonException("'method' must not be null for injection");
        }
    }

    public InjectionPoint parseInjectionPoint(JsonMethods methods) {
        switch (this.type) {
            case INVOKE: {
                return this.applyShift(new BeforeInvoke(methods.get(this.getTarget()), this.ordinal));
            }
            case INVOKESTRING: {
                return this.applyShift(new BeforeStringInvoke(this.getArg(0).toString(), methods.get(this.getTarget()), this.ordinal));
            }
            case RETURN: {
                return this.applyShift(new BeforeReturn(this.ordinal));
            }
            case HEAD: {
                return new MethodHead();
            }
            case CUSTOM: {
                try {
                    Class<?> injectionPointClass = Class.forName(this.className);
                    if (this.args != null) {
                        Constructor<?> ctor = injectionPointClass.getDeclaredConstructor(Object[].class);
                        return (InjectionPoint)ctor.newInstance(this.args);
                    }
                    return (InjectionPoint)injectionPointClass.newInstance();
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        throw new InvalidEventJsonException("Could not parse injection type");
    }

    private Object getArg(int arg) {
        if (this.args == null || this.args.length >= this.args.length || arg < 0) {
            return "";
        }
        return this.args[arg];
    }

    private String getTarget() {
        if (this.target != null && this.shift == null) {
            if (this.target.startsWith("before(") && this.target.endsWith(")")) {
                this.target = this.target.substring(7, this.target.length() - 1);
                this.shift = JsonInjectionShiftType.BEFORE;
            } else if (this.target.startsWith("after(") && this.target.endsWith(")")) {
                this.target = this.target.substring(6, this.target.length() - 1);
                this.shift = JsonInjectionShiftType.AFTER;
            }
        }
        if (this.target == null) {
            throw new InvalidEventJsonException("'target' is required for injection type " + this.type.name());
        }
        return this.target;
    }

    private InjectionPoint applyShift(InjectionPoint injectionPoint) {
        if (this.shift != null) {
            switch (this.shift) {
                case AFTER: {
                    return InjectionPoint.after(injectionPoint);
                }
                case BEFORE: {
                    return InjectionPoint.before(injectionPoint);
                }
            }
            return injectionPoint;
        }
        return injectionPoint;
    }
}

