/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.util;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;

public abstract class EntityUtilities {
    static final Predicate<vg> TRACEABLE = Predicates.and((Predicate)vk.e, (Predicate)new Predicate<vg>(){

        public boolean apply(vg entity) {
            return entity != null && entity.ay();
        }
    });

    public static bhc rayTraceFromEntity(vg source, double traceDistance, float partialTicks, boolean includeEntities) {
        bhc blockRay = EntityUtilities.rayTraceFromEntity(source, traceDistance, partialTicks);
        if (!includeEntities) {
            return blockRay;
        }
        bhe traceStart = EntityUtilities.getPositionEyes(source, partialTicks);
        double blockDistance = blockRay != null ? blockRay.c.f(traceStart) : traceDistance;
        EntityTrace entityRay = EntityUtilities.rayTraceEntities(source, traceDistance, partialTicks, blockDistance, traceStart);
        if (entityRay.entity != null && (entityRay.distance < blockDistance || blockRay == null)) {
            return entityRay.asRayTraceResult();
        }
        return blockRay;
    }

    private static EntityTrace rayTraceEntities(vg source, double traceDistance, float partialTicks, double blockDistance, bhe traceStart) {
        EntityTrace trace = new EntityTrace(blockDistance);
        bhe lookDir = source.e(partialTicks).a(traceDistance);
        bhe traceEnd = traceStart.e(lookDir);
        for (vg entity : EntityUtilities.getTraceEntities(source, traceDistance, lookDir, TRACEABLE)) {
            double distanceToEntity;
            bhb entityBB = entity.bw().g((double)entity.aI());
            bhc entityRay = entityBB.b(traceStart, traceEnd);
            if (entityBB.b(traceStart)) {
                if (!(trace.distance >= 0.0)) continue;
                trace.entity = entity;
                trace.location = entityRay == null ? traceStart : entityRay.c;
                trace.distance = 0.0;
                continue;
            }
            if (entityRay == null || !((distanceToEntity = traceStart.f(entityRay.c)) < trace.distance) && trace.distance != 0.0) continue;
            if (entity.bH() == source.bH()) {
                if (trace.distance != 0.0) continue;
                trace.entity = entity;
                trace.location = entityRay.c;
                continue;
            }
            trace.entity = entity;
            trace.location = entityRay.c;
            trace.distance = distanceToEntity;
        }
        return trace;
    }

    private static List<vg> getTraceEntities(vg source, double traceDistance, bhe dir, Predicate<vg> filter) {
        bhb boundingBox = source.bw();
        bhb traceBox = boundingBox.b(dir.b, dir.c, dir.d);
        List entities = source.l.a(source, traceBox.b(1.0, 1.0, 1.0), filter);
        return entities;
    }

    public static bhc rayTraceFromEntity(vg source, double traceDistance, float partialTicks) {
        bhe traceStart = EntityUtilities.getPositionEyes(source, partialTicks);
        bhe lookDir = source.e(partialTicks).a(traceDistance);
        bhe traceEnd = traceStart.e(lookDir);
        return source.l.a(traceStart, traceEnd, false, false, true);
    }

    public static bhe getPositionEyes(vg entity, float partialTicks) {
        if (partialTicks == 1.0f) {
            return new bhe(entity.p, entity.q + (double)entity.by(), entity.r);
        }
        double interpX = entity.m + (entity.p - entity.m) * (double)partialTicks;
        double interpY = entity.n + (entity.q - entity.n) * (double)partialTicks + (double)entity.by();
        double interpZ = entity.o + (entity.r - entity.o) * (double)partialTicks;
        return new bhe(interpX, interpY, interpZ);
    }

    static final class EntityTrace {
        vg entity;
        bhe location;
        double distance;

        EntityTrace(double entityDistance) {
            this.distance = entityDistance;
        }

        bhc asRayTraceResult() {
            return new bhc(this.entity, this.location);
        }
    }
}

