/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.util.log;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.MissingFormatArgumentException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.appender.AbstractAppender;

public class LiteLoaderLogger
extends AbstractAppender {
    public static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("liteloader.debug", "false"));
    private static final int LOG_TAIL_SIZE = 500;
    private static Logger logger = (Logger)LogManager.getLogger((String)"LiteLoader");
    private static Deque<String> logTail = new LinkedList<String>();
    private static long logIndex = 0L;
    private static Throwable lastThrowable;
    private static Verbosity verbosity;

    protected LiteLoaderLogger() {
        super("Internal Log Appender", null, null);
        this.start();
    }

    public static void setVerbosity(Verbosity verbosity) {
        LiteLoaderLogger.verbosity = verbosity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(LogEvent event) {
        Deque<String> deque = logTail;
        synchronized (deque) {
            ++logIndex;
            this.append(event.getTimeMillis(), event.getMessage().getFormattedMessage());
            Throwable thrown = event.getThrown();
            if (thrown != null) {
                this.append(event.getTimeMillis(), String.format("\u00a74%s: \u00a76%s", thrown.getClass().getSimpleName(), thrown.getMessage()));
            }
        }
    }

    private void append(long timestamp, String message) {
        String date = new SimpleDateFormat("[HH:mm:ss] ").format(new Date(timestamp));
        while (message.indexOf(10) > -1) {
            int lineFeedPos = message.indexOf(10);
            this.appendLine(date + message.substring(0, lineFeedPos));
            message = message.substring(lineFeedPos + 1);
        }
        this.appendLine(date + message);
    }

    private void appendLine(String line) {
        logTail.add(line);
        if (logTail.size() > 500) {
            logTail.remove();
        }
    }

    public static long getLogIndex() {
        return logIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getLogTail() {
        ArrayList<String> log = new ArrayList<String>();
        Deque<String> deque = logTail;
        synchronized (deque) {
            log.addAll(logTail);
        }
        return log;
    }

    public static Logger getLogger() {
        return logger;
    }

    public static void clearLastThrowable() {
        lastThrowable = null;
    }

    public static Throwable getLastThrowable() {
        Throwable lastThrowableWrapped = null;
        if (lastThrowable != null) {
            StringWriter sw = new StringWriter();
            lastThrowable.printStackTrace(new PrintWriter(sw));
            lastThrowableWrapped = new Throwable(sw.toString());
            try {
                sw.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return lastThrowableWrapped;
    }

    private static void log(Level level, Verbosity verbosity, String format, Object ... data) {
        if (verbosity.level > LiteLoaderLogger.verbosity.level) {
            return;
        }
        try {
            logger.log(level, String.format(format, data));
        }
        catch (MissingFormatArgumentException ex) {
            logger.log(level, format.replace('%', '@'));
        }
    }

    private static void log(Level level, Verbosity verbosity, Throwable th, String format, Object ... data) {
        if (verbosity.level > LiteLoaderLogger.verbosity.level) {
            return;
        }
        lastThrowable = th;
        try {
            logger.log(level, String.format(format, data), th);
        }
        catch (LinkageError ex) {
            th.printStackTrace();
        }
        catch (Throwable th2) {
            th2.initCause(th);
            th2.printStackTrace();
        }
    }

    public static void severe(String format, Object ... data) {
        LiteLoaderLogger.severe(Verbosity.REDUCED, format, data);
    }

    public static void severe(Verbosity verbosity, String format, Object ... data) {
        LiteLoaderLogger.log(Level.ERROR, verbosity, format, data);
    }

    public static void severe(Throwable th, String format, Object ... data) {
        LiteLoaderLogger.severe(Verbosity.REDUCED, th, format, data);
    }

    public static void severe(Verbosity verbosity, Throwable th, String format, Object ... data) {
        lastThrowable = th;
        try {
            LiteLoaderLogger.log(Level.ERROR, verbosity, th, format, data);
        }
        catch (LinkageError ex) {
            th.printStackTrace();
        }
        catch (Throwable th2) {
            th2.initCause(th);
            th2.printStackTrace();
        }
    }

    public static void warning(String format, Object ... data) {
        LiteLoaderLogger.warning(Verbosity.REDUCED, format, data);
    }

    public static void warning(Verbosity verbosity, String format, Object ... data) {
        LiteLoaderLogger.log(Level.WARN, verbosity, format, data);
    }

    public static void warning(Throwable th, String format, Object ... data) {
        LiteLoaderLogger.warning(Verbosity.REDUCED, th, format, data);
    }

    public static void warning(Verbosity verbosity, Throwable th, String format, Object ... data) {
        lastThrowable = th;
        try {
            LiteLoaderLogger.log(Level.WARN, verbosity, th, format, data);
        }
        catch (LinkageError ex) {
            th.printStackTrace();
        }
        catch (Throwable th2) {
            th2.initCause(th);
            th2.printStackTrace();
        }
    }

    public static void info(String format, Object ... data) {
        LiteLoaderLogger.info(Verbosity.NORMAL, format, data);
    }

    public static void info(Verbosity verbosity, String format, Object ... data) {
        LiteLoaderLogger.log(Level.INFO, verbosity, format, data);
    }

    public static void debug(String format, Object ... data) {
        if (DEBUG) {
            System.err.printf("[DEBUG] %s\n", String.format(format, data));
        }
    }

    public static void debug(Throwable th, String format, Object ... data) {
        if (DEBUG) {
            th.printStackTrace();
            LiteLoaderLogger.debug(format, data);
        }
    }

    public static void debug(Throwable th) {
        if (DEBUG) {
            th.printStackTrace();
        }
    }

    static {
        verbosity = DEBUG ? Verbosity.VERBOSE : Verbosity.NORMAL;
        logger.addAppender((Appender)new LiteLoaderLogger());
    }

    public static enum Verbosity {
        VERBOSE(3),
        NORMAL(2),
        REDUCED(1),
        SILENT(0);

        protected final int level;

        private Verbosity(int level) {
            this.level = level;
        }

        public int getLevel() {
            return this.level;
        }
    }
}

