/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.webprefs;

import com.mumfrey.webprefs.WebPreferences;
import com.mumfrey.webprefs.interfaces.IWebPreferences;
import java.util.Set;
import java.util.UUID;

abstract class AbstractWebPreferences
implements IWebPreferences {
    protected final String uuid;
    protected final boolean isPrivate;
    protected final boolean isReadOnly;

    AbstractWebPreferences(UUID uuid, boolean isPrivate, boolean isReadOnly) {
        this(uuid.toString(), isPrivate, isReadOnly);
    }

    AbstractWebPreferences(String uuid, boolean isPrivate, boolean isReadOnly) {
        this.uuid = uuid;
        this.isPrivate = isPrivate;
        this.isReadOnly = isReadOnly;
    }

    void onTick() {
    }

    @Override
    public final String getUUID() {
        return this.uuid;
    }

    @Override
    public final boolean isPrivate() {
        return this.isPrivate;
    }

    @Override
    public final boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    public void request(String key) {
        WebPreferences.validateKey(key);
    }

    @Override
    public void request(String ... keys) {
        if (keys == null || keys.length < 1) {
            return;
        }
        if (keys.length == 1) {
            this.request(keys[0]);
        }
        for (String key : keys) {
            this.request(key);
        }
    }

    @Override
    public void request(Set<String> keys) {
        if (keys == null || keys.size() < 1) {
            return;
        }
        for (String key : keys) {
            this.request(key);
        }
    }

    @Override
    public void commit(boolean force) {
    }

    @Override
    public void set(String key, String value) {
        WebPreferences.validateKey(key);
    }

    @Override
    public void remove(String key) {
        this.set(key, "");
    }
}

