/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.webprefs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mumfrey.liteloader.core.LiteLoader;
import com.mumfrey.webprefs.DummyOfflineWebPreferences;
import com.mumfrey.webprefs.WebPreferences;
import com.mumfrey.webprefs.exceptions.ReadOnlyPreferencesException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

class OfflineWebPreferences
extends DummyOfflineWebPreferences {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static final int COMMIT_RATE = 60;
    private final File store;
    final Map<String, String> prefs;
    private int tickNumber;
    private boolean isDirty;

    OfflineWebPreferences(UUID uuid, boolean isPrivate, boolean isReadOnly) {
        this(uuid.toString(), isPrivate, isReadOnly);
    }

    OfflineWebPreferences(String uuid, boolean isPrivate, boolean isReadOnly) {
        super(uuid, isPrivate, isReadOnly);
        this.store = new File(LiteLoader.getCommonConfigFolder(), String.format("%s.%sprefs.json", uuid, isPrivate ? "private" : ""));
        this.prefs = this.loadValues();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> loadValues() {
        if (this.store.isFile()) {
            FileReader reader = null;
            try {
                reader = new FileReader(this.store);
                Map map = (Map)gson.fromJson((Reader)reader, Map.class);
                return map;
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return new HashMap<String, String>();
    }

    private void saveValues() {
        FileWriter writer = null;
        try {
            writer = new FileWriter(this.store);
            gson.toJson(this.prefs, (Appendable)writer);
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    void onTick() {
        if (this.tickNumber++ > 60 && this.isDirty) {
            this.isDirty = false;
            this.tickNumber = 0;
            this.saveValues();
        }
    }

    @Override
    public void request(String key) {
        WebPreferences.validateKey(key);
        if (!this.prefs.containsKey(key)) {
            this.prefs.put(key, "");
        }
    }

    @Override
    public void commit(boolean force) {
        this.isDirty = true;
    }

    @Override
    public boolean has(String key) {
        WebPreferences.validateKey(key);
        return this.prefs.containsKey(key);
    }

    @Override
    public String get(String key) {
        return this.get(key, "");
    }

    @Override
    public String get(String key, String defaultValue) {
        WebPreferences.validateKey(key);
        String value = this.prefs.get(key);
        return value != null ? value : defaultValue;
    }

    @Override
    public void set(String key, String value) {
        if (this.isReadOnly()) {
            throw new ReadOnlyPreferencesException("Preference collection for " + this.uuid + " is read-only");
        }
        WebPreferences.validateKV(key, value);
        this.prefs.put(key, value);
        this.isDirty = true;
    }
}

