/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.webprefs;

import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import com.mumfrey.webprefs.AbstractWebPreferences;
import com.mumfrey.webprefs.exceptions.InvalidKeyException;
import com.mumfrey.webprefs.exceptions.InvalidValueException;
import com.mumfrey.webprefs.exceptions.ReadOnlyPreferencesException;
import com.mumfrey.webprefs.framework.RequestFailureReason;
import com.mumfrey.webprefs.interfaces.IWebPreferencesClient;
import com.mumfrey.webprefs.interfaces.IWebPreferencesProvider;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

class WebPreferences
extends AbstractWebPreferences {
    private static final int UPDATE_FREQUENCY_TICKS = 20;
    private static final int REQUEST_TIMEOUT_TICKS = 1200;
    private static final int UPDATE_ERROR_SUSPEND_TICKS = 1200;
    private static final Pattern keyPattern = Pattern.compile("^[a-z0-9_\\-\\.]{1,32}$");
    private final IWebPreferencesProvider provider;
    private final IWebPreferencesClient client;
    protected final Map<String, String> prefs = new ConcurrentHashMap<String, String>();
    protected final Set<String> requestedPrefs = new HashSet<String>();
    protected final Set<String> pendingPrefs = new HashSet<String>();
    protected final Set<String> dirtyPrefs = new HashSet<String>();
    protected final Object lock = new Object();
    protected volatile boolean dirty = false;
    private volatile int updateCheckTimer = 1;
    protected int requestTimeoutTimer = 0;

    WebPreferences(IWebPreferencesProvider provider, UUID uuid, boolean isPrivate, boolean isReadOnly) {
        this(provider, uuid.toString(), isPrivate, isReadOnly);
    }

    WebPreferences(IWebPreferencesProvider provider, String uuid, boolean isPrivate, boolean isReadOnly) {
        super(uuid, isPrivate, isReadOnly);
        this.provider = provider;
        this.client = new Client();
    }

    @Override
    void onTick() {
        if (this.updateCheckTimer > 0 && --this.updateCheckTimer < 1) {
            this.update();
        }
        if (this.requestTimeoutTimer > 0 && --this.requestTimeoutTimer < 1) {
            this.handleTimeout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        this.updateCheckTimer = 20;
        if (!this.dirty || !this.provider.isActive()) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.dirty = false;
            if (this.requestedPrefs.size() > 0) {
                LiteLoaderLogger.debug("Preferences for " + this.uuid + " is submitting a request for " + this.requestedPrefs.size() + " requested preferences", new Object[0]);
                if (this.provider.requestGet(this.client, this.uuid, new HashSet<String>(this.requestedPrefs), this.isPrivate)) {
                    this.requestTimeoutTimer = 1200;
                    this.pendingPrefs.addAll(this.requestedPrefs);
                    this.requestedPrefs.clear();
                } else {
                    this.dirty = true;
                }
            }
        }
        this.commit(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTimeout() {
        this.updateCheckTimer = 1200;
        Object object = this.lock;
        synchronized (object) {
            this.requestedPrefs.addAll(this.pendingPrefs);
            this.pendingPrefs.clear();
            this.dirty = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void request(String key) {
        WebPreferences.validateKey(key);
        Object object = this.lock;
        synchronized (object) {
            this.dirty |= this.addRequestedKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void request(String ... keys) {
        if (keys.length < 1) {
            return;
        }
        if (keys.length == 1) {
            this.request(keys[0]);
        }
        Object object = this.lock;
        synchronized (object) {
            boolean dirty = false;
            for (String key : keys) {
                WebPreferences.validateKey(key);
                dirty |= this.addRequestedKey(key);
            }
            this.dirty |= dirty;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void request(Set<String> keys) {
        if (keys == null || keys.size() < 1) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            boolean dirty = false;
            for (String key : keys) {
                WebPreferences.validateKey(key);
                dirty |= this.addRequestedKey(key);
            }
            this.dirty |= dirty;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void poll() {
        Object object = this.lock;
        synchronized (object) {
            this.requestedPrefs.addAll(this.prefs.keySet());
            this.requestedPrefs.removeAll(this.pendingPrefs);
            this.dirty = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(boolean force) {
        Object object = this.lock;
        synchronized (object) {
            if (this.updateCheckTimer < 0) {
                return;
            }
            if (force) {
                this.dirtyPrefs.addAll(this.prefs.keySet());
            }
            if (this.dirtyPrefs.size() > 0) {
                HashMap<String, String> outgoingPrefs = new HashMap<String, String>();
                for (String key : this.dirtyPrefs) {
                    outgoingPrefs.put(key, this.prefs.get(key));
                }
                LiteLoaderLogger.debug("Preferences for " + this.uuid + " is submitting a SET for " + outgoingPrefs.size() + " dirty preferences", new Object[0]);
                if (this.provider.requestSet(this.client, this.uuid, outgoingPrefs, this.isPrivate)) {
                    this.dirtyPrefs.clear();
                } else {
                    this.dirty = true;
                }
            }
        }
    }

    @Override
    public boolean has(String key) {
        WebPreferences.validateKey(key);
        return this.get(key) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String get(String key) {
        WebPreferences.validateKey(key);
        String value = this.prefs.get(key);
        if (value == null) {
            Object object = this.lock;
            synchronized (object) {
                this.dirty |= this.addRequestedKey(key);
            }
        }
        return value;
    }

    @Override
    public String get(String key, String defaultValue) {
        WebPreferences.validateKey(key);
        String value = this.get(key);
        return value != null ? value : defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(String key, String value) {
        if (this.isReadOnly()) {
            throw new ReadOnlyPreferencesException("Preference collection for " + this.uuid + " is read-only");
        }
        WebPreferences.validateKV(key, value);
        Object object = this.lock;
        synchronized (object) {
            String oldValue = this.prefs.get(key);
            if (value.equals(oldValue)) {
                return;
            }
            this.prefs.put(key, value);
            this.dirtyPrefs.add(key);
            this.requestedPrefs.remove(key);
            this.dirty = true;
        }
    }

    private boolean addRequestedKey(String key) {
        if (key != null && !this.pendingPrefs.contains(key)) {
            this.requestedPrefs.add(key);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onGetRequestSuccess(Map<String, String> values) {
        this.requestTimeoutTimer = 0;
        Object object = this.lock;
        synchronized (object) {
            this.prefs.putAll(values);
            Set<String> keys = values.keySet();
            this.dirtyPrefs.removeAll(keys);
            this.pendingPrefs.removeAll(keys);
            this.requestedPrefs.removeAll(keys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onSetRequestSuccess(Set<String> keys) {
        this.requestTimeoutTimer = 0;
        Object object = this.lock;
        synchronized (object) {
            this.dirtyPrefs.removeAll(keys);
            this.requestedPrefs.removeAll(keys);
            this.dirty = this.dirtyPrefs.size() > 0 || this.requestedPrefs.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onGetRequestFailed(Set<String> keys, RequestFailureReason reason) {
        this.requestTimeoutTimer = 0;
        this.handleFailedRequest(reason);
        Object object = this.lock;
        synchronized (object) {
            this.dirtyPrefs.addAll(keys);
            this.pendingPrefs.removeAll(keys);
            this.dirty = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onSetRequestFailed(Set<String> keys, RequestFailureReason reason) {
        this.requestTimeoutTimer = 0;
        this.handleFailedRequest(reason);
        Object object = this.lock;
        synchronized (object) {
            this.requestedPrefs.addAll(keys);
            this.pendingPrefs.removeAll(keys);
            this.dirty = true;
        }
    }

    private void handleFailedRequest(RequestFailureReason reason) {
        if (reason.isPermanent()) {
            LiteLoaderLogger.debug("Halting update of preferences for " + this.uuid + " permanently because " + (Object)((Object)reason), new Object[0]);
            this.updateCheckTimer = -1;
        }
        int suspendUpdateFor = 1200 * Math.max(1, reason.getSeverity());
        LiteLoaderLogger.debug("Suspending update of preferences for " + this.uuid + " for " + suspendUpdateFor + " because " + (Object)((Object)reason), new Object[0]);
        this.updateCheckTimer = suspendUpdateFor;
    }

    protected static void validateKey(String key) {
        if (key == null || !keyPattern.matcher(key).matches()) {
            throw new InvalidKeyException("The specified key [" + key + "] is not valid");
        }
    }

    protected static void validateKV(String key, String value) {
        WebPreferences.validateKey(key);
        if (value == null || value.length() > 255) {
            throw new InvalidValueException("The specified value [" + value + "] for key [" + key + "] is not valid");
        }
    }

    class Client
    implements IWebPreferencesClient {
        Client() {
        }

        @Override
        public void onGetRequestSuccess(String uuid, Map<String, String> values) {
            if (!WebPreferences.this.uuid.equals(uuid)) {
                throw new RuntimeException("Received unsolicited response");
            }
            WebPreferences.this.onGetRequestSuccess(values);
        }

        @Override
        public void onSetRequestSuccess(String uuid, Set<String> keys) {
            if (!WebPreferences.this.uuid.equals(uuid)) {
                throw new RuntimeException("Received unsolicited response");
            }
            WebPreferences.this.onSetRequestSuccess(keys);
        }

        @Override
        public void onGetRequestFailed(String uuid, Set<String> keys, RequestFailureReason reason) {
            if (!WebPreferences.this.uuid.equals(uuid)) {
                throw new RuntimeException("Received unsolicited response");
            }
            WebPreferences.this.onGetRequestFailed(keys, reason);
        }

        @Override
        public void onSetRequestFailed(String uuid, Set<String> keys, RequestFailureReason reason) {
            if (!WebPreferences.this.uuid.equals(uuid)) {
                throw new RuntimeException("Received unsolicited response");
            }
            WebPreferences.this.onSetRequestFailed(keys, reason);
        }
    }
}

