/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client;

import com.mrcrayfish.obfuscate.client.event.ModelPlayerEvent;
import com.mrcrayfish.vehicle.client.render.layer.LayerHeldVehicle;
import com.mrcrayfish.vehicle.common.entity.HeldVehicleDataHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class HeldVehicleEvents {
    private static boolean setupExtraLayers = false;
    public static final Map<UUID, AnimationCounter> idToCounter = new HashMap<UUID, AnimationCounter>();

    @SubscribeEvent
    public void onRenderPlayer(RenderPlayerEvent.Pre event) {
        if (!setupExtraLayers) {
            Render render = Minecraft.func_71410_x().func_175598_ae().func_78715_a(AbstractClientPlayer.class);
            Map skinMap = render.func_177068_d().getSkinMap();
            this.patchPlayerRender((RenderPlayer)skinMap.get("default"));
            this.patchPlayerRender((RenderPlayer)skinMap.get("slim"));
            setupExtraLayers = true;
        }
    }

    private void patchPlayerRender(RenderPlayer player) {
        List layers = (List)ObfuscationReflectionHelper.getPrivateValue(RenderLivingBase.class, (Object)player, (String[])new String[]{"field_177097_h"});
        if (layers != null) {
            layers.add(new LayerHeldVehicle());
        }
    }

    @SubscribeEvent
    public void onSetupAngles(ModelPlayerEvent.SetupAngles.Post event) {
        AnimationCounter counter;
        ModelPlayer model = event.getModelPlayer();
        EntityPlayer player = event.getEntityPlayer();
        boolean holdingVehicle = HeldVehicleDataHandler.isHoldingVehicle(player);
        if (holdingVehicle && !idToCounter.containsKey(player.func_110124_au())) {
            idToCounter.put(player.func_110124_au(), new AnimationCounter(40));
        } else if (idToCounter.containsKey(player.func_110124_au())) {
            if (idToCounter.get(player.func_110124_au()).getProgress(event.getPartialTicks()) == 0.0f) {
                idToCounter.remove(player.func_110124_au());
                return;
            }
            if (!holdingVehicle) {
                counter = idToCounter.get(player.func_110124_au());
                player.field_70761_aq = player.func_70079_am() - (player.func_70079_am() - player.field_70760_ar) * counter.getProgress(event.getPartialTicks());
            }
        } else {
            return;
        }
        counter = idToCounter.get(player.func_110124_au());
        counter.update(holdingVehicle);
        float progress = counter.getProgress(event.getPartialTicks());
        model.field_178723_h.field_78795_f = (float)Math.toRadians(-180.0f * progress);
        model.field_178723_h.field_78808_h = (float)Math.toRadians(-5.0f * progress);
        model.field_178723_h.field_78797_d = -1.5f * progress;
        model.field_178724_i.field_78795_f = (float)Math.toRadians(-180.0f * progress);
        model.field_178724_i.field_78808_h = (float)Math.toRadians(5.0f * progress);
        model.field_178724_i.field_78797_d = -1.5f * progress;
    }

    public static class AnimationCounter {
        private final int MAX_COUNT;
        private int prevCount;
        private int currentCount;

        private AnimationCounter(int maxCount) {
            this.MAX_COUNT = maxCount;
        }

        public int update(boolean increment) {
            this.prevCount = this.currentCount;
            if (increment) {
                if (this.currentCount < this.MAX_COUNT) {
                    ++this.currentCount;
                }
            } else if (this.currentCount > 0) {
                this.currentCount = Math.max(0, this.currentCount - 2);
            }
            return this.currentCount;
        }

        public int getMaxCount() {
            return this.MAX_COUNT;
        }

        public int getCurrentCount() {
            return this.currentCount;
        }

        public float getProgress(float partialTicks) {
            return ((float)this.prevCount + (float)(this.currentCount - this.prevCount) * partialTicks) / (float)this.MAX_COUNT;
        }
    }
}

