/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.render.vehicle;

import com.mrcrayfish.vehicle.client.SpecialModels;
import com.mrcrayfish.vehicle.client.render.AbstractRenderVehicle;
import com.mrcrayfish.vehicle.common.Seat;
import com.mrcrayfish.vehicle.entity.VehicleProperties;
import com.mrcrayfish.vehicle.entity.vehicle.EntityAluminumBoat;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.Vec3d;

public class RenderAluminumBoat
extends AbstractRenderVehicle<EntityAluminumBoat> {
    private final ModelRenderer noWater = new ModelRenderer(new ModelBase(){}, 0, 0).func_78787_b(0, 0);

    public RenderAluminumBoat() {
        this.noWater.func_78790_a(-15.0f, -4.0f, -21.0f, 30, 8, 35, 0.0f);
    }

    @Override
    public void render(EntityAluminumBoat entity, float partialTicks) {
        this.renderDamagedPart(entity, SpecialModels.ALUMINUM_BOAT_BODY.getModel());
    }

    @Override
    public void applyPlayerModel(EntityAluminumBoat entity, EntityPlayer player, ModelPlayer model, float partialTicks) {
        model.field_178721_j.field_78795_f = (float)Math.toRadians(-85.0);
        model.field_178721_j.field_78796_g = (float)Math.toRadians(20.0);
        model.field_178722_k.field_78795_f = (float)Math.toRadians(-85.0);
        model.field_178722_k.field_78796_g = (float)Math.toRadians(-20.0);
    }

    @Override
    public void applyPlayerRender(EntityAluminumBoat entity, EntityPlayer player, float partialTicks) {
        int index = entity.getSeatTracker().getSeatIndex(player.func_110124_au());
        if (index != -1) {
            VehicleProperties properties = entity.getProperties();
            Seat seat = properties.getSeats().get(index);
            Vec3d seatVec = seat.getPosition().func_72441_c(0.0, (double)(properties.getAxleOffset() + properties.getWheelOffset()), 0.0).func_186678_a(properties.getBodyPosition().getScale());
            seatVec = new Vec3d(-seatVec.field_72450_a, seatVec.field_72448_b, seatVec.field_72449_c);
            seatVec = seatVec.func_186678_a(0.0625);
            double scale = 1.0666666666666667;
            double offsetX = -seatVec.field_72450_a * scale;
            double offsetY = (seatVec.field_72448_b + player.func_70033_W()) * scale + 1.5;
            double offsetZ = seatVec.field_72449_c * scale;
            GlStateManager.func_179137_b((double)offsetX, (double)offsetY, (double)offsetZ);
            float currentSpeedNormal = (entity.prevCurrentSpeed + (entity.currentSpeed - entity.prevCurrentSpeed) * partialTicks) / entity.getMaxSpeed();
            float turnAngleNormal = (entity.prevTurnAngle + (entity.turnAngle - entity.prevTurnAngle) * partialTicks) / (float)entity.getMaxTurnAngle();
            GlStateManager.func_179114_b((float)(-8.0f * Math.min(1.0f, currentSpeedNormal)), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(turnAngleNormal * currentSpeedNormal * 15.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)(-offsetX), (double)(-offsetY), (double)(-offsetZ));
        }
    }
}

