/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.common.entity;

import com.mrcrayfish.vehicle.network.PacketHandler;
import com.mrcrayfish.vehicle.network.message.MessageSyncHeldVehicle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class HeldVehicleDataHandler {
    @CapabilityInject(value=IHeldVehicle.class)
    public static final Capability<IHeldVehicle> CAPABILITY_HELD_VEHICLE = null;

    public static void register() {
        CapabilityManager.INSTANCE.register(IHeldVehicle.class, (Capability.IStorage)new Storage(), HeldVehicle::new);
        MinecraftForge.EVENT_BUS.register((Object)new HeldVehicleDataHandler());
    }

    public static boolean isHoldingVehicle(EntityPlayer player) {
        IHeldVehicle handler = HeldVehicleDataHandler.getHandler(player);
        if (handler != null) {
            return !handler.getVehicleTag().func_82582_d();
        }
        return false;
    }

    public static NBTTagCompound getHeldVehicle(EntityPlayer player) {
        IHeldVehicle handler = HeldVehicleDataHandler.getHandler(player);
        if (handler != null) {
            return handler.getVehicleTag();
        }
        return new NBTTagCompound();
    }

    public static void setHeldVehicle(EntityPlayer player, NBTTagCompound vehicleTag) {
        IHeldVehicle handler = HeldVehicleDataHandler.getHandler(player);
        if (handler != null) {
            handler.setVehicleTag(vehicleTag);
        }
        if (!player.field_70170_p.field_72995_K) {
            PacketHandler.INSTANCE.sendTo((IMessage)new MessageSyncHeldVehicle(player.func_145782_y(), vehicleTag), (EntityPlayerMP)player);
            PacketHandler.INSTANCE.sendToAllTracking((IMessage)new MessageSyncHeldVehicle(player.func_145782_y(), vehicleTag), (Entity)player);
        }
    }

    @Nullable
    public static IHeldVehicle getHandler(EntityPlayer player) {
        if (player.hasCapability(CAPABILITY_HELD_VEHICLE, EnumFacing.DOWN)) {
            return (IHeldVehicle)player.getCapability(CAPABILITY_HELD_VEHICLE, EnumFacing.DOWN);
        }
        return null;
    }

    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(new ResourceLocation("vehicle", "held_vehicle"), (ICapabilityProvider)new Provider());
        }
    }

    @SubscribeEvent
    public void onStartTracking(PlayerEvent.StartTracking event) {
        if (event.getTarget() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getTarget();
            NBTTagCompound vehicleTag = HeldVehicleDataHandler.getHeldVehicle(player);
            PacketHandler.INSTANCE.sendTo((IMessage)new MessageSyncHeldVehicle(player.func_145782_y(), vehicleTag), (EntityPlayerMP)event.getEntityPlayer());
        }
    }

    @SubscribeEvent
    public void onPlayerJoinWorld(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof EntityPlayer && !event.getWorld().field_72995_K) {
            EntityPlayer player = (EntityPlayer)entity;
            NBTTagCompound vehicleTag = HeldVehicleDataHandler.getHeldVehicle(player);
            PacketHandler.INSTANCE.sendTo((IMessage)new MessageSyncHeldVehicle(player.func_145782_y(), vehicleTag), (EntityPlayerMP)player);
        }
    }

    public static class Provider
    implements ICapabilitySerializable<NBTTagCompound> {
        final IHeldVehicle INSTANCE = (IHeldVehicle)CAPABILITY_HELD_VEHICLE.getDefaultInstance();

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CAPABILITY_HELD_VEHICLE;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(this.hasCapability(capability, facing) ? CAPABILITY_HELD_VEHICLE.cast((Object)this.INSTANCE) : null);
        }

        public NBTTagCompound serializeNBT() {
            return (NBTTagCompound)CAPABILITY_HELD_VEHICLE.getStorage().writeNBT(CAPABILITY_HELD_VEHICLE, (Object)this.INSTANCE, null);
        }

        public void deserializeNBT(NBTTagCompound tagCompound) {
            CAPABILITY_HELD_VEHICLE.getStorage().readNBT(CAPABILITY_HELD_VEHICLE, (Object)this.INSTANCE, null, (NBTBase)tagCompound);
        }
    }

    public static class Storage
    implements Capability.IStorage<IHeldVehicle> {
        @Nullable
        public NBTBase writeNBT(Capability<IHeldVehicle> capability, IHeldVehicle instance, EnumFacing side) {
            return instance.getVehicleTag();
        }

        public void readNBT(Capability<IHeldVehicle> capability, IHeldVehicle instance, EnumFacing side, NBTBase nbt) {
            instance.setVehicleTag((NBTTagCompound)nbt);
        }
    }

    public static class HeldVehicle
    implements IHeldVehicle {
        private NBTTagCompound tagCompound = new NBTTagCompound();

        @Override
        public void setVehicleTag(NBTTagCompound tagCompound) {
            this.tagCompound = tagCompound;
        }

        @Override
        public NBTTagCompound getVehicleTag() {
            return this.tagCompound;
        }
    }

    public static interface IHeldVehicle {
        public void setVehicleTag(NBTTagCompound var1);

        public NBTTagCompound getVehicleTag();
    }
}

